package com.example.removetolocal.oldentity;

import lombok.Data;
import javax.persistence.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for dev_repair
 * 设备操作日志
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "dev_repair")
public class DevRepair {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* title
	*/
	@Column(name = "title")
	private String title;
	/**
	* 文号
	*/
	@Column(name = "docNo")
	private String docNo;
	/**
	* 申请单位
	*/
	@Column(name = "applyUnit")
	private String applyUnit;
	/**
	* 申请人
	*/
	@Column(name = "applyUser")
	private String applyUser;
	/**
	* 申请时间
	*/
	@Column(name = "applyTime")
	private java.util.Date applyTime;
	/**
	* 申请确认人
	*/
	@Column(name = "applyConfirmUser")
	private String applyConfirmUser;
	/**
	* 维修单位
	*/
	@Column(name = "handleUnit")
	private String handleUnit;
	/**
	* 维修经手人
	*/
	@Column(name = "handleUser")
	private String handleUser;
	/**
	* handleTime
	*/
	@Column(name = "handleTime")
	private java.util.Date handleTime;
	/**
	* 维修核验人
	*/
	@Column(name = "handleConfirmUser")
	private String handleConfirmUser;
	/**
	* 状态 1.送修待确认 2.待接收 3.接收待确认 4.结束
	*/
	@Column(name = "status")
	private Integer status;
	/**
	* total
	*/
	@Column(name = "total")
	private Integer total;
	/**
	* 维修单文件id
	*/
	@Column(name = "billFileid")
	private Integer billFileid;
	/**
	* 修复完成数量
	*/
	@Column(name = "repairTotal")
	private Integer repairTotal;
	/**
	* 回执单号
	*/
	@Column(name = "receiptNum")
	private String receiptNum;
	/**
	* 附件
	*/
	@Column(name = "annex")
	private String annex;

}
