package com.example.removetolocal.oldtrain;

import com.example.removetolocal.newtrain.entity.TrainUser;
import lombok.Data;
import javax.persistence.*;

/**
 * entity class for dev_train_enroll
 * 培训报名
*/
@Data
@Entity
@Table(name = "dev_train_enroll")
public class DevTrainEnroll {

	/**
	* 主键
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* 培训id
	*/
	@Column(name = "train_id")
	private Integer trainId;
	/**
	* 培训主办方
	*/
	@Column(name = "host")
	private String host;
	/**
	* 培训主题
	*/
	@Column(name = "theme")
	private String theme;
	/**
	* 专管员id
	*/
	@Column(name = "vmanager_id")
	private String vmanagerId;
	/**
	* 专管员姓名
	*/
	@Column(name = "vmanager_name")
	private String vmanagerName;
	/**
	* 所在组织
	*/
	@Column(name = "ownsup")
	private String ownsup;
	/**
	* 所属组织名称
	*/
	@Column(name = "ownsup_name")
	private String ownsupName;
	/**
	* 状态:1.任务未读 2.已报名 3.忽略报名 4.参加考试 5.缺席考试
	*/
	@Column(name = "status")
	private Integer status;
	/**
	* 报名时间
	*/
	@Column(name = "enroll_time")
	private java.util.Date enrollTime;
	/**
	* 得分
	*/
	@Column(name = "score")
	private Double score;


}
