package com.example.removetolocal.service.impl;

import com.example.removetolocal.config.base.GlobalMap;
import com.example.removetolocal.newdevice.dao.DeviceLibraryDao;
import com.example.removetolocal.newdevice.domin.DeviceLibrary;
import com.example.removetolocal.newentity.dao.*;
import com.example.removetolocal.newentity.entity.RepairBackBill;
import com.example.removetolocal.newentity.entity.RepairBill;
import com.example.removetolocal.newentity.entity.RepairDetail;
import com.example.removetolocal.newentity.entity.RepairSendBill;
import com.example.removetolocal.newrepair.vo.ScriptSaveVo;
import com.example.removetolocal.newstorage.bto.TaskBto;
import com.example.removetolocal.newentity.entity.Task;
import com.example.removetolocal.newentity.entity.TaskLog;
import com.example.removetolocal.newuser.dao.UnitsDao;
import com.example.removetolocal.newuser.dao.UserDao;
import com.example.removetolocal.oldentity.*;
import com.example.removetolocal.oldentity.dao.*;
import com.example.removetolocal.service.RepairService;
import com.example.removetolocal.service.UserService;
import com.example.removetolocal.utils.JacksonUtil;
import com.example.removetolocal.utils.StringSplitUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Service
public class RepairServiceImpl implements RepairService {

    @Autowired
    NewRepairBillDao repairBillDao;
    @Autowired
    NewRepairSendBillDao repairSendBillDao;
    @Autowired
    NewRepairDetailDao repairDetailDao;
    @Autowired
    NewRepairBackBillDao repairBackBillDao;
    @Autowired
    DevRepairDao devRepairDao;
    @Autowired
    DevRepairdetailDao devRepairdetailDao;
    @Autowired
    DevRepairReceiveDao devRepairReceiveDao;
    @Autowired
    DevRepairReceivedetailDao devRepairReceivedetailDao;
    @Autowired
    UserService userService;
    @Autowired
    DeviceLibraryDao deviceLibraryDao;
    @Autowired
    DevTaskmainDao devTaskmainDao;
    @Autowired
    NewTaskDao taskDao;
    @Autowired
    DevTasklogDao devTasklogDao;
    @Autowired
    NewTaskLogDao taskLogDao;
    @Autowired
    UnitsDao unitsDao;
    @Autowired
    UserDao userDao;
    /**
     * 送修业务转换
     */
    @Override
    public void moveRepair() {
        //转换送修单
        List<DevRepair> devRepairs = devRepairDao.findAll();
        devRepairs.forEach(devRepair -> {
            List<DevRepairdetail> devRepairdetails = devRepairdetailDao.findAllByRepairid(devRepair.getId());
            if (devRepair.getStatus()>0){
                RepairBill repairBill = new RepairBill();
                repairBill.setCreateTime(devRepair.getApplyTime());
                repairBill.setUpdateTime(devRepair.getHandleTime());
                if (!checkcountname(devRepair.getApplyUser())&&(userDao.findByOldCode(devRepair.getApplyUser()) != null || userDao.findByOldId(devRepair.getApplyUser()) != null)) {
                    repairBill.setCreateUserId(userDao.findByOldCode(devRepair.getApplyUser()) == null ? userDao.findByOldId(devRepair.getApplyUser()).getUserId() : userDao.findByOldCode(devRepair.getApplyUser()).getUserId());
                }
                if (devRepair.getHandleConfirmUser()==null||checkcountname(devRepair.getHandleConfirmUser())){
                    repairBill.setUpdateUserId(repairBill.getCreateUserId());
                }
                else if (!checkcountname(devRepair.getHandleConfirmUser())&&(userDao.findByOldCode(devRepair.getHandleConfirmUser()) != null || userDao.findByOldId(devRepair.getHandleConfirmUser()) != null)) {
                    repairBill.setUpdateUserId(userDao.findByOldCode(devRepair.getHandleConfirmUser()) == null ? userDao.findByOldId(devRepair.getHandleConfirmUser()).getUserId() : userDao.findByOldCode(devRepair.getHandleConfirmUser()).getUserId());
                }
                repairBill.setDocNum(devRepair.getDocNo());
                repairBill.setReceiveUnit(userService.getUnitNameByOldId(devRepair.getHandleUnit()));
                repairBill.setSendUnit(userService.getUnitNameByOldId(devRepair.getApplyUnit()));
                if (devRepair.getStatus()==4) {
                    repairBill.setRepairStatus(4);
                }
                else {
                    repairBill.setRepairStatus(2);
                }
                if (devRepair.getHandleUser()!=null&&!"".equals(devRepair.getHandleUser())) {
                    repairBill.setRepairUsera(userService.getUserNameByOldId(devRepair.getHandleUser()));
                }
                if (devRepair.getHandleConfirmUser()!=null&&!"".equals(devRepair.getHandleConfirmUser())) {
                    repairBill.setRepairUserb(userService.getUserNameByOldId(devRepair.getHandleConfirmUser()));
                }
                if (devRepair.getApplyUser()!=null&&!"".equals(devRepair.getApplyUser())) {
                    repairBill.setStartUsera(userService.getUserNameByOldId(devRepair.getApplyUser()));
                }
                if (devRepair.getApplyConfirmUser()!=null&&!"".equals(devRepair.getApplyConfirmUser())) {
                    repairBill.setStartUserb(userService.getUserNameByOldId(devRepair.getApplyConfirmUser()));
                }
                repairBill.setOldId(devRepair.getId());
                RepairBill repairBill1 = repairBillDao.save(repairBill);
                RepairSendBill repairSendBill = new RepairSendBill();
                repairSendBill.setAgent(repairBill1.getStartUserb());
                repairSendBill.setCreateUserId(repairBill1.getCreateUserId());
                repairSendBill.setCreateTime(repairBill1.getCreateTime());
                repairSendBill.setUpdateTime(repairBill1.getUpdateTime());
                repairSendBill.setUpdateUserId(repairBill1.getUpdateUserId());
                repairSendBill.setDeviceRepairBillId(repairBill1.getId());
                repairSendBill.setReceiveCount(devRepair.getTotal());
                repairSendBill.setSendedCount(devRepair.getTotal());
                repairSendBill.setSendingCount(devRepair.getTotal());
                repairSendBill.setReceiveTime(devRepair.getHandleTime());
                repairSendBill.setReceiveUnit(repairBill1.getReceiveUnit());
                if (devRepair.getStatus()==4) {
                    repairSendBill.setRepairStatus(5);
                }
                else {
                    repairSendBill.setRepairStatus(2);
                }
                repairSendBill.setRepairDeviceCheckResult("0x0");
                repairSendBill.setRepairReciveCheckResult("0x0");
                repairSendBill.setSendFiles(devRepair.getReceiptNum());
                repairSendBill.setReceiveFiles(devRepair.getAnnex());
                List<Integer> deviceIds = new ArrayList<>();
                StringBuffer stringBuffer = new StringBuffer();
                devRepairdetailDao.findAllByRepairid(devRepair.getId()).forEach(devRepairdetail -> {
                    stringBuffer.append(devRepairdetail.getDevId());
                    stringBuffer.append("Ǵ");
                    stringBuffer.append(devRepairdetail.getErrorDesc());
                    stringBuffer.append("Ǵ");
                    deviceIds.add(deviceLibraryDao.findByOldId(devRepairdetail.getDevId()).getId());
                });
                repairSendBill.setRepairDeviceCheckDetail(StringSplitUtil.idListToCheckString(deviceIds));
                repairSendBill.setRepairReciveCheckDetail(repairSendBill.getRepairDeviceCheckDetail());
                repairSendBill.setRepairDeviceDetail(stringBuffer.toString());
                repairSendBill.setRepairUsera(repairBill1.getRepairUsera());
                if (devRepair.getHandleUser()!=null&&userService.getUserByOldId(devRepair.getHandleUser())!=null) {
                    repairSendBill.setRepairUseraId(userService.getUserByOldId(devRepair.getHandleUser()).getUserId());
                }
                if (devRepair.getHandleConfirmUser()!=null&&userService.getUserByOldId(devRepair.getHandleConfirmUser())!=null) {
                    repairSendBill.setRepairUserbId(userService.getUserByOldId(devRepair.getHandleConfirmUser()).getUserId());
                }
                if (devRepair.getApplyUser()!=null&&userService.getUserByOldId(devRepair.getApplyUser())!=null) {
                    repairSendBill.setStartUseraId(userService.getUserByOldId(devRepair.getApplyUser()).getUserId());
                }
                if (devRepair.getApplyConfirmUser()!=null&&userService.getUserByOldId(devRepair.getApplyConfirmUser())!=null) {
                    repairSendBill.setStartUserbId(userService.getUserByOldId(devRepair.getApplyConfirmUser()).getUserId());
                }
                repairSendBill.setSendTime(repairBill1.getCreateTime());
                repairSendBill.setSendUnit(repairBill1.getSendUnit());
                repairSendBill.setTitle(devRepair.getTitle());
                repairSendBill.setOldId(devRepair.getId());
                RepairSendBill repairSendBill1 = repairSendBillDao.save(repairSendBill);
                //detail
                devRepairdetailDao.findAllByRepairid(devRepair.getId()).forEach(devRepairdetail -> {
                    DeviceLibrary deviceLibrary = deviceLibraryDao.findByOldId(devRepairdetail.getDevId());
                    RepairDetail repairDetail = new RepairDetail();
                    repairDetail.setCreateUserId(repairBill1.getCreateUserId());
                    repairDetail.setCreateTime(repairBill1.getCreateTime());
                    repairDetail.setUpdateTime(repairBill1.getUpdateTime());
                    repairDetail.setUpdateUserId(repairBill1.getUpdateUserId());
                    repairDetail.setDeviceId(deviceLibraryDao.findByOldId(devRepairdetail.getDevId()).getId());
                    repairDetail.setDeviceRepairBillId(repairBill1.getId());
                    repairDetail.setModel(devRepairdetail.getModel());
                    repairDetail.setName(deviceLibrary.getName());
                    repairDetail.setOwnUnit(userService.getUnitNameByOldId(devRepairdetail.getOwnUnit()));
                    repairDetail.setLocationUnit(userService.getUnitNameByOldId(devRepairdetail.getHandleUnit()));
                    repairDetail.setRemark(devRepairdetail.getErrorDesc());
                    if (devRepairdetail.getFrontRepairid()!=null) {
                        repairDetail.setPid(repairDetailDao.findByOldId(devRepairdetail.getFrontRepairid()).getId());
                    }
                    if (devRepairdetail.getStatus()==7) {
                        repairDetail.setRepairStatus(5);
                    }
                    else if (devRepairdetail.getStatus()==1){
                        repairDetail.setRepairStatus(0);
                        if (repairDetail.getPid()!=null){
                            RepairDetail repairDetail1 = repairDetailDao.findById(repairDetail.getPid()).get();
                            repairDetail1.setRepairStatus(8);
                            repairDetailDao.save(repairDetail1);
                            if (repairDetail1.getPid()!=null){
                                RepairDetail repairDetail2 = repairDetailDao.findById(repairDetail1.getPid()).get();
                                repairDetail2.setRepairStatus(8);
                                repairDetailDao.save(repairDetail2);
                            }
                        }
                    }
                    else if (devRepairdetail.getStatus()==2){
                        repairDetail.setRepairStatus(0);
                        if (repairDetail.getPid()!=null){
                            RepairDetail repairDetail1 = repairDetailDao.findById(repairDetail.getPid()).get();
                            repairDetail1.setRepairStatus(8);
                            repairDetailDao.save(repairDetail1);
                            if (repairDetail1.getPid()!=null){
                                RepairDetail repairDetail2 = repairDetailDao.findById(repairDetail1.getPid()).get();
                                repairDetail2.setRepairStatus(8);
                                repairDetailDao.save(repairDetail2);
                            }
                        }
                    }
                    else if(devRepairdetail.getStatus()==3){
                        repairDetail.setRepairStatus(1);
                    }
                    else if (devRepairdetail.getStatus()==4||devRepairdetail.getStatus()==5){
                        repairDetail.setRepairStatus(2);
                        if (repairDetail.getPid()!=null){
                            RepairDetail repairDetail1 = repairDetailDao.findById(repairDetail.getPid()).get();
                            repairDetail1.setRepairStatus(8);
                            repairDetailDao.save(repairDetail1);
                            if (repairDetail1.getPid()!=null){
                                RepairDetail repairDetail2 = repairDetailDao.findById(repairDetail1.getPid()).get();
                                repairDetail2.setRepairStatus(8);
                                repairDetailDao.save(repairDetail2);
                            }
                        }
                    }
                    repairDetail.setRfidSurfaceId(deviceLibrary.getRfidSurfaceId());
                    repairDetail.setSeqNumber(deviceLibrary.getSeqNumber());
                    repairDetail.setType(deviceLibrary.getType());
                    repairDetail.setRepairBackBillId(devRepairdetail.getRepairReceiveid());
                    repairDetail.setOldId(devRepairdetail.getId());
                    repairDetail.setBackRemark(devRepairdetail.getRepairDesc());
                    repairDetailDao.save(repairDetail);
                });
                //set scriptSaveVo
                repairSendBillDao.findAll().forEach(repairSendBill2 -> {
                    List<ScriptSaveVo> scriptSaveVos = new ArrayList<>();
                    List<RepairDetail> repairDetails = repairDetailDao.findByDeviceRepairBillId(repairSendBill2.getDeviceRepairBillId());
                    repairDetails.forEach(repairDetail -> {
                        ScriptSaveVo scriptSaveVo = new ScriptSaveVo();
                        DeviceLibrary deviceLibrary = deviceLibraryDao.findById(repairDetail.getDeviceId()).get();
                        scriptSaveVo.setDetailId(repairDetail.getId());
                        scriptSaveVo.setAllotType(GlobalMap.getMatchingRangeMap().get(deviceLibrary.getMatchingRange()).name);
                        scriptSaveVo.setAllotTypeNum(String.valueOf(deviceLibrary.getMatchingRange()));
                        scriptSaveVo.setId(deviceLibrary.getId());
                        scriptSaveVo.setInvisibleRange(GlobalMap.getDeviceInvisibleRangeMap().get(deviceLibrary.getInvisibleRange()).name);
                        scriptSaveVo.setModel(deviceLibrary.getModel());
                        scriptSaveVo.setName(deviceLibrary.getName());
                        scriptSaveVo.setNum(1);
                        scriptSaveVo.setRemark(repairDetail.getRemark());
                        scriptSaveVo.setSecretLevel(GlobalMap.getDeviceSecretLevelMap().get(deviceLibrary.getSecretLevel()).name);
                        scriptSaveVo.setSeqNumber(repairDetail.getSeqNumber());
                        scriptSaveVo.setType(GlobalMap.getDeviceStyleMap().get(deviceLibrary.getType()).name);
                        scriptSaveVos.add(scriptSaveVo);
                    });
                    repairSendBill2.setScriptJson(JacksonUtil.toJSon(scriptSaveVos));
                    repairSendBillDao.save(repairSendBill2);
                 });
                //task转换
                DevTaskmain devTaskmain = devTaskmainDao.findByTypeAndResourceId(3,devRepair.getId());
                if (devTaskmain.getIsComplete()==1||devTaskmain.getIsSeal()==1) {
                    TaskBto taskBto = devTaskmain.parseToTaskBto();
                    taskBto.setBillId(repairBill1.getId());
                    taskBto.setOldId(devTaskmain.getId());
                    if ("1".equals(devRepair.getApplyUnit())){
                        taskBto.setBillStatus(704);
                        taskBto.setCustomInfo("country");
                    }
                    Task task = taskDao.save(taskBto.toDo2());
                    //添加业务日志
                    List<DevTasklog> devTasklogs = devTasklogDao.findAllByTaskId(devTaskmain.getId());
                    devTasklogs.forEach(devTasklog -> {
                        TaskLog taskLog = new TaskLog();
                        taskLog.setCreateTime(devTasklog.getOperateTime());
                        taskLog.setCreateUserId(userService.getUserByOldId(devTasklog.getOperater()).getUserId());
                        taskLog.setUpdateTime(taskLog.getCreateTime());
                        taskLog.setUpdateUserId(taskLog.getCreateUserId());
                        taskLog.setFileDetail("Ǵ");
                        taskLog.setRemark(devTasklog.getNote());
                        taskLog.setTaskId(task.getId());
                        taskLog.setOldId(devTasklog.getId());
                        taskLogDao.save(taskLog);
                    });
                }
                else if (devRepair.getStatus()==2){
                    TaskBto taskBto = devTaskmain.parseToTaskBto();
                    taskBto.setBillId(repairBill1.getId());
                    taskBto.setOldId(devTaskmain.getId());
                    taskBto.setBillStatus(701);
                    Task task = taskDao.save(taskBto.toDo2());
                    //生成子任务（发件方上传回执单）
                    TaskBto taskBto2 = new TaskBto(722, task.getTitle(), task.getId(), task.getNodeIdDetail() + task.getId() + ".", task.getBillId(), 5, unitsDao.findByOldId(devRepair.getApplyUnit()).getUnitId(), 0, null, Collections.singletonList(0));
                    taskBto2.setCreateUserId(task.getCreateUserId());
                    taskBto2.setCreateTime(task.getCreateTime());
                    taskBto2.setUpdateUserId(task.getCreateUserId());
                    taskBto2.setUpdateTime(task.getCreateTime());
                    taskDao.save(taskBto2.toDo2());
                    //添加业务日志
                    List<DevTasklog> devTasklogs = devTasklogDao.findAllByTaskId(devTaskmain.getId());
                    devTasklogs.forEach(devTasklog -> {
                        TaskLog taskLog = new TaskLog();
                        taskLog.setCreateTime(devTasklog.getOperateTime());
                        taskLog.setCreateUserId(userService.getUserByOldId(devTasklog.getOperater()).getUserId());
                        taskLog.setUpdateTime(taskLog.getCreateTime());
                        taskLog.setUpdateUserId(taskLog.getCreateUserId());
                        taskLog.setFileDetail("Ǵ");
                        taskLog.setRemark(devTasklog.getNote());
                        taskLog.setTaskId(task.getId());
                        taskLog.setOldId(devTasklog.getId());
                        taskLogDao.save(taskLog);
                    });
                }
            }
        });
    }

    /**
     * 维修退回业务转换
     */
    @Override
    public void moveRepairBack() {
        //转换送修单
        List<DevRepairReceive> devRepairReceives = devRepairReceiveDao.findAll();
        devRepairReceives.forEach(devRepairReceive -> {
            if (devRepairReceive.getStatus()==4){
                RepairBackBill repairBackBill = new RepairBackBill();
                repairBackBill.setCreateTime(devRepairReceive.getApplyTime());
                repairBackBill.setUpdateTime(devRepairReceive.getHandleTime());
                if (!checkcountname(devRepairReceive.getApplyUser())&&(userDao.findByOldCode(devRepairReceive.getApplyUser()) != null || userDao.findByOldId(devRepairReceive.getApplyUser()) != null)) {
                    repairBackBill.setCreateUserId(userDao.findByOldCode(devRepairReceive.getApplyUser()) == null ? userDao.findByOldId(devRepairReceive.getApplyUser()).getUserId() : userDao.findByOldCode(devRepairReceive.getApplyUser()).getUserId());
                }
                if (devRepairReceive.getHandleConfirmUser()==null||checkcountname(devRepairReceive.getHandleConfirmUser())){
                    repairBackBill.setUpdateUserId(repairBackBill.getCreateUserId());
                }
                else if (!checkcountname(devRepairReceive.getHandleConfirmUser())&&(userDao.findByOldCode(devRepairReceive.getHandleConfirmUser()) != null || userDao.findByOldId(devRepairReceive.getHandleConfirmUser()) != null)) {
                    repairBackBill.setUpdateUserId(userDao.findByOldCode(devRepairReceive.getHandleConfirmUser()) == null ? userDao.findByOldId(devRepairReceive.getHandleConfirmUser()).getUserId() : userDao.findByOldCode(devRepairReceive.getHandleConfirmUser()).getUserId());
                }
                repairBackBill.setReceiveCount(devRepairReceive.getTotal());
                repairBackBill.setSendedCount(devRepairReceive.getTotal());
                repairBackBill.setSendingCount(devRepairReceive.getTotal());
                repairBackBill.setReceiveTime(devRepairReceive.getHandleTime());
                repairBackBill.setReceiveUnit(userService.getUnitNameByOldId(devRepairReceive.getHandleUnit()));
                repairBackBill.setBackStatus(5);
                repairBackBill.setBackCheckResult("0x0");
                repairBackBill.setBackReciveCheckResult("0x0");
                List<Integer> deviceIds = new ArrayList<>();
                devRepairReceivedetailDao.findAllByRepairReceiveId(devRepairReceive.getId()).forEach(devRepairReceivedetail -> {
                    deviceIds.add(deviceLibraryDao.findByOldId(devRepairReceivedetail.getDevId()).getId());
                });
                repairBackBill.setBackCheckDetail(StringSplitUtil.idListToCheckString(deviceIds));
                repairBackBill.setBackReciveCheckDetail(repairBackBill.getBackCheckDetail());
                if (devRepairReceive.getHandleUser()!=null&&userService.getUserByOldId(devRepairReceive.getHandleUser())!=null) {
                    repairBackBill.setReceiveUseraId(userService.getUserByOldId(devRepairReceive.getHandleUser()).getUserId());
                }
                if (devRepairReceive.getHandleConfirmUser()!=null&&userService.getUserByOldId(devRepairReceive.getHandleConfirmUser())!=null) {
                    repairBackBill.setReceiveUserbId(userService.getUserByOldId(devRepairReceive.getHandleConfirmUser()).getUserId());
                }
                if (devRepairReceive.getApplyUser()!=null&&userService.getUserByOldId(devRepairReceive.getApplyUser())!=null) {
                    repairBackBill.setStartUseraId(userService.getUserByOldId(devRepairReceive.getApplyUser()).getUserId());
                }
                if (devRepairReceive.getApplyConfirmUser()!=null) {
                    if (userService.getUserByOldId(devRepairReceive.getApplyConfirmUser())!=null) {
                        repairBackBill.setStartUserbId(userService.getUserByOldId(devRepairReceive.getApplyConfirmUser()).getUserId());
                        repairBackBill.setAgent(userService.getUserByOldId(devRepairReceive.getApplyConfirmUser()).getName());
                    }
                    else {
                        repairBackBill.setAgent(userService.getUserNameByOldId(devRepairReceive.getApplyConfirmUser()));
                    }
                }
                repairBackBill.setSendTime(devRepairReceive.getApplyTime());
                repairBackBill.setSendUnit(userService.getUnitNameByOldId(devRepairReceive.getApplyUnit()));
                repairBackBill.setTitle(devRepairReceive.getTitle());
                repairBackBill.setOldId(devRepairReceive.getId());
                repairBackBill.setSendFiles(devRepairReceive.getAnnex());
                repairBackBill.setReceiveFiles(devRepairReceive.getHandleannex());
                RepairBackBill repairBackBill1 = repairBackBillDao.save(repairBackBill);
                //task转换
                DevTaskmain devTaskmain = devTaskmainDao.findByTypeAndResourceId(4,devRepairReceive.getId());
                if (devTaskmain.getIsComplete()==1||devTaskmain.getIsSeal()==1) {
                    TaskBto taskBto = devTaskmain.parseToTaskBto();
                    taskBto.setBillId(repairBackBill1.getId());
                    taskBto.setOldId(devTaskmain.getId());
                    Task task = taskDao.save(taskBto.toDo2());
                    //添加业务日志
                    List<DevTasklog> devTasklogs = devTasklogDao.findAllByTaskId(devTaskmain.getId());
                    devTasklogs.forEach(devTasklog -> {
                        TaskLog taskLog = new TaskLog();
                        taskLog.setCreateTime(devTasklog.getOperateTime());
                        taskLog.setCreateUserId(userService.getUserByOldId(devTasklog.getOperater()).getUserId());
                        taskLog.setUpdateTime(taskLog.getCreateTime());
                        taskLog.setUpdateUserId(taskLog.getCreateUserId());
                        taskLog.setFileDetail("Ǵ");
                        taskLog.setRemark(devTasklog.getNote());
                        taskLog.setTaskId(task.getId());
                        taskLog.setOldId(devTasklog.getId());
                        taskLogDao.save(taskLog);
                    });
                }
            }
        });
        //set scriptSaveVo
        repairBackBillDao.findAll().forEach(repairBackBill -> {
            List<ScriptSaveVo> scriptSaveVos = new ArrayList<>();
            List<DevRepairReceivedetail> repairDetails = devRepairReceivedetailDao.findAllByRepairReceiveId(repairBackBill.getOldId());
            repairDetails.forEach(devRepairReceivedetail -> {
                ScriptSaveVo scriptSaveVo = new ScriptSaveVo();
                DeviceLibrary deviceLibrary = deviceLibraryDao.findByOldId(devRepairReceivedetail.getDevId());
                scriptSaveVo.setDetailId(devRepairReceivedetail.getRepairDetailId());
                scriptSaveVo.setAllotType(GlobalMap.getMatchingRangeMap().get(deviceLibrary.getMatchingRange()).name);
                scriptSaveVo.setAllotTypeNum(String.valueOf(deviceLibrary.getMatchingRange()));
                scriptSaveVo.setId(deviceLibrary.getId());
                scriptSaveVo.setInvisibleRange(GlobalMap.getDeviceInvisibleRangeMap().get(deviceLibrary.getInvisibleRange()).name);
                scriptSaveVo.setModel(deviceLibrary.getModel());
                scriptSaveVo.setName(deviceLibrary.getName());
                scriptSaveVo.setNum(1);
                scriptSaveVo.setSecretLevel(GlobalMap.getDeviceSecretLevelMap().get(deviceLibrary.getSecretLevel()).name);
                scriptSaveVo.setSeqNumber(devRepairReceivedetail.getSerNum());
                scriptSaveVo.setType(GlobalMap.getDeviceStyleMap().get(deviceLibrary.getType()).name);
                scriptSaveVo.setRemark(repairDetailDao.findByOldId(scriptSaveVo.getDetailId()).getBackRemark());
                scriptSaveVos.add(scriptSaveVo);
            });
            repairBackBill.setScriptJson(JacksonUtil.toJSon(scriptSaveVos));
            repairBackBillDao.save(repairBackBill);
        });
        //set detail receiveId
        repairDetailDao.findAll().forEach(repairDetail -> {
            if (repairDetail.getRepairBackBillId()!=null){
                if (repairBackBillDao.findByOldId(repairDetail.getRepairBackBillId())!=null) {
                    repairDetail.setRepairBackBillId(repairBackBillDao.findByOldId(repairDetail.getRepairBackBillId()).getId());
                }
                else {
                    repairDetail.setRepairBackBillId(null);
                }
                repairDetailDao.save(repairDetail);
            }
        });
    }

    public boolean checkcountname(String countname){
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = p.matcher(countname);
        if (m.find()) {
            return true;
        }
        return false;
    }
}
