package com.example.removetolocal.newdevice.domin;

import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * entity class for device_library
 * 装备库
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update device_library set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@Table(name = "device_library")
public class DeviceLibrary {

    /**
     * 主键id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;
    /**
     * 入库单id
     */
    @Column(name = "storage_bill_id")
    private Integer storageBillId;
    /**
     * 列装id
     */
    @Column(name = "packing_id")
    private Integer packingId;
    /**
     * 是不是配件(0:不是，1:是)
     */
    @Column(name = "is_part")
    private Integer isPart;
    /**
     * 配件对应装备id
     */
    @Column(name = "part_parent_id")
    private Integer partParentId;
    /**
     * 型号
     */
    private String model;
    /**
     * 密级
     */
    @Column(name = "secret_level")
    private Integer secretLevel;
    /**
     * 装备名称
     */
    private String name;
    /**
     * 装备序列号
     */
    @Column(name = "seq_number")
    private String seqNumber;
    /**
     * 生产序列号
     */
    @Column(name = "prod_number")
    private String prodNumber;
    /**
     * rfid表面号
     */
    @Column(name = "rfid_surface_id")
    private String rfidSurfaceId;
    /**
     * rfid卡号
     */
    @Column(name = "rfid_card_id")
    private String rfidCardId;
    /**
     * 所在单位
     */
    @Column(name = "location_unit")
    private String locationUnit;
    /**
     * 所属单位
     */
    @Column(name = "own_unit")
    private String ownUnit;
    /**
     * 配用范围,1-省对下纵向
     */
    @Column(name = "matching_range")
    private Integer matchingRange;
    /**
     * 可见范围
     */
    @Column(name = "invisible_range")
    private Integer invisibleRange;
    /**
     * 类型
     */
    private Integer type;
    /**
     * 入库类型，1-横向，2-纵向
     */
    @Column(name = "storage_type")
    private Integer storageType;
    /**
     * 管理状态,0-不再所属单位,1-在所属单位
     */
    @Column(name = "manage_status")
    private Integer manageStatus;
    /**
     * 生命状态,0-入库待审核,1-入库审核失败,2-在库,3-配发,4-维修,5,维修失败,6-退回,7-待退装,8-退装,9-待销毁,10-已销毁,11-丢失
     */
    @Column(name = "life_status")
    private Integer lifeStatus;
    /**
     * 锁定状态,0-未锁定可用,1-锁定不可用
     */
    @Column(name = "lock_status")
    private Integer lockStatus = 0;
    /**
     * 图片名称
     */
    @Column(name = "image_name")
    private String imageName;
    /**
     * 图片url地址
     */
    @Column(name = "image_url")
    private String imageUrl;
    /**
     * 货架位置
     */
    private String position;
    /**
     * 创建用户id
     */
    @CreatedBy
    @Column(name = "create_user_id")
    private Integer createUserId;
    /**
     * 创建时间
     */
    @CreatedDate
    @Column(name = "create_time")
    private Date createTime;
    /**
     * 更新用户id
     */
    @LastModifiedBy
    @Column(name = "update_user_id")
    private Integer updateUserId;
    /**
     * 更新时间
     */
    @LastModifiedDate
    @Column(name = "update_time")
    private Date updateTime;
    /**
     * 删除标记(0:未删除，1:已删除)
     */
    @Column(name = "delete_tag")
    private Integer deleteTag = 0;

    @Column(name = "record_id")
    private String recordId;

    @Column(name = "old_id")
    private Integer oldId;

}
