package com.example.removetolocal.newentity;

import lombok.AllArgsConstructor;
import lombok.Data;
import javax.persistence.*;

import lombok.NoArgsConstructor;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for device_apply_bill
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "device_apply_bill")
public class DeviceApplyBill {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* agent
	*/
	@Column(name = "agent")
	private String agent;
	/**
	* allotId
	*/
	@Column(name = "allot_id")
	private Integer allotId;
	/**
	* applyDetail
	*/
	@Column(name = "apply_detail")
	private String applyDetail;
	/**
	* applyNumber
	*/
	@Column(name = "apply_number")
	private String applyNumber;
	/**
	* applyStatus
	*/
	@Column(name = "apply_status")
	private Integer applyStatus;
	/**
	* applyUnit
	*/
	@Column(name = "apply_unit")
	private String applyUnit;
	/**
	* applyUseraId
	*/
	@Column(name = "apply_usera_id")
	private Integer applyUseraId;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private java.util.Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* replayNumber
	*/
	@Column(name = "replay_number")
	private String replayNumber;
	/**
	* replyUnit
	*/
	@Column(name = "reply_unit")
	private String replyUnit;
	/**
	* replyUseraId
	*/
	@Column(name = "reply_usera_id")
	private Integer replyUseraId;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private java.util.Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;

}
