package com.example.removetolocal.newentity;

import lombok.AllArgsConstructor;
import lombok.Data;
import javax.persistence.*;

import lombok.NoArgsConstructor;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for final_report
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "final_report")
public class FinalReport {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* endTime
	*/
	@Column(name = "end_time")
	private java.sql.Date endTime;
	/**
	* operator
	*/
	@Column(name = "operator")
	private String operator;
	/**
	* reportTime
	*/
	@Column(name = "report_time")
	private java.sql.Date reportTime;
	/**
	* startTime
	*/
	@Column(name = "start_time")
	private java.sql.Date startTime;
	/**
	* unitName
	*/
	@Column(name = "unit_name")
	private String unitName;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private java.util.Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private java.util.Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* name
	*/
	@Column(name = "name")
	private String name;

}
