package com.example.removetolocal.newentity;

import lombok.AllArgsConstructor;
import lombok.Data;
import javax.persistence.*;

import lombok.NoArgsConstructor;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for library_warning_log
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "library_warning_log")
public class LibraryWarningLog {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* actualQuantity
	*/
	@Column(name = "actual_quantity")
	private String actualQuantity;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private java.util.Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* dueQuantity
	*/
	@Column(name = "due_quantity")
	private String dueQuantity;
	/**
	* inventoryResults
	*/
	@Column(name = "inventory_results")
	private String inventoryResults;
	/**
	* status
	*/
	@Column(name = "status")
	private String status;
	/**
	* unit
	*/
	@Column(name = "unit")
	private String unit;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private java.util.Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* warningHandle
	*/
	@Column(name = "warning_handle")
	private Integer warningHandle;
	/**
	* warningType
	*/
	@Column(name = "warning_type")
	private Integer warningType;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;

}
