package com.example.removetolocal.newentity;

import lombok.AllArgsConstructor;
import lombok.Data;
import javax.persistence.*;

import lombok.NoArgsConstructor;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for rfid_change_log
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "rfid_change_log")
public class RfidChangeLog {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private java.util.Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* deviceId
	*/
	@Column(name = "device_id")
	private Integer deviceId;
	/**
	* newCardId
	*/
	@Column(name = "new_card_id")
	private String newCardId;
	/**
	* oldCardId
	*/
	@Column(name = "old_card_id")
	private String oldCardId;
	/**
	* rfidChangeBillId
	*/
	@Column(name = "rfid_change_bill_id")
	private Integer rfidChangeBillId;
	/**
	* unit
	*/
	@Column(name = "unit")
	private String unit;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private java.util.Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* useraid
	*/
	@Column(name = "useraid")
	private Integer useraid;
	/**
	* userbid
	*/
	@Column(name = "userbid")
	private Integer userbid;
	/**
	* validTag
	*/
	@Column(name = "valid_tag")
	private Integer validTag;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;

}
