package com.example.removetolocal.newentity;

import lombok.AllArgsConstructor;
import lombok.Data;
import javax.persistence.*;

import lombok.NoArgsConstructor;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for send_back_bill
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "send_back_bill")
public class SendBackBill {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private java.util.Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* deadLine
	*/
	@Column(name = "dead_line")
	private java.util.Date deadLine;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* exceptionDes
	*/
	@Column(name = "exception_des")
	private String exceptionDes;
	/**
	* formId
	*/
	@Column(name = "form_id")
	private Integer formId;
	/**
	* involeDevice
	*/
	@Column(name = "invole_device")
	private String involeDevice;
	/**
	* reviewUserId
	*/
	@Column(name = "review_user_id")
	private Integer reviewUserId;
	/**
	* sendBackOut
	*/
	@Column(name = "send_back_out")
	private String sendBackOut;
	/**
	* sendBackOutForm
	*/
	@Column(name = "send_back_out_form")
	private String sendBackOutForm;
	/**
	* sendBackStatistical
	*/
	@Column(name = "send_back_statistical")
	private String sendBackStatistical;
	/**
	* title
	*/
	@Column(name = "title")
	private String title;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private java.util.Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* isComplete
	*/
	@Column(name = "is_complete")
	private Integer isComplete;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;

}
