package com.example.removetolocal.newentity;

import lombok.AllArgsConstructor;
import lombok.Data;
import javax.persistence.*;

import lombok.NoArgsConstructor;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for task
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "task")
public class Task {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* billId
	*/
	@Column(name = "bill_id")
	private Integer billId;
	/**
	* billStatus
	*/
	@Column(name = "bill_status")
	private Integer billStatus;
	/**
	* businessType
	*/
	@Column(name = "business_type")
	private Integer businessType;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private java.util.Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* currentPoint
	*/
	@Column(name = "current_point")
	private Integer currentPoint;
	/**
	* customInfo
	*/
	@Column(name = "custom_info")
	private String customInfo;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* involveUsers
	*/
	@Column(name = "involve_users")
	private String involveUsers;
	/**
	* nodeIdDetail
	*/
	@Column(name = "node_id_detail")
	private String nodeIdDetail;
	/**
	* ownUnit
	*/
	@Column(name = "own_unit")
	private Integer ownUnit;
	/**
	* parentTaskId
	*/
	@Column(name = "parent_task_id")
	private Integer parentTaskId;
	/**
	* title
	*/
	@Column(name = "title")
	private String title;
	/**
	* topFlagDetail
	*/
	@Column(name = "top_flag_detail")
	private String topFlagDetail;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private java.util.Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* userReadDetail
	*/
	@Column(name = "user_read_detail")
	private String userReadDetail;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;

}
