package com.example.removetolocal.newtrain.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.*;

/**
 * entity class for work_handover
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "work_handover")
public class WorkHandover {

	/**
	* workHandoverId
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "work_handover_id")
	private Integer workHandoverId;
	/**
	* commissionWord
	*/
	@Column(name = "commission_word")
	private String commissionWord;
	/**
	* fileLists
	*/
	@Column(name = "file_lists")
	private String fileLists;
	/**
	* handoverUserId
	*/
	@Column(name = "handover_user_id")
	private Integer handoverUserId;
	/**
	* inUserName
	*/
	@Column(name = "in_user_name")
	private String inUserName;
	/**
	* trackingWord
	*/
	@Column(name = "tracking_word")
	private String trackingWord;
	/**
	* turnOverUserId
	*/
	@Column(name = "turn_over_user_id")
	private Integer turnOverUserId;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private Integer createTime;
	/**
	* status
	*/
	@Column(name = "status")
	private Integer status;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private Integer updateTime;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;

}
