package com.example.removetolocal.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateSettings;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import javax.persistence.EntityManager;
import javax.sql.DataSource;
import java.util.HashMap;
import java.util.Map;

/**
 * @author zjm
 */
@SuppressWarnings("ALL")
@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(
        entityManagerFactoryRef = "entityManagerFactoryBackup",
        transactionManagerRef = "transactionManagerBackup",
        basePackages = {
        "com.example.removetolocal.newentity.dao"}
)
@EnableConfigurationProperties(JpaProperties.class)
public class BackupConfig {
    @Autowired
    @Qualifier("backupDataSource")
    private DataSource remoteDataSource;

    @Autowired
    private HibernateProperties properties;

    @Bean(name = "entityManagerBackup")
    public EntityManager entityManager(EntityManagerFactoryBuilder builder) {
        return entityManagerFactoryStms(builder).getObject().createEntityManager();
    }

    @Bean(name = "entityManagerFactoryBackup")
    public LocalContainerEntityManagerFactoryBean entityManagerFactoryStms(EntityManagerFactoryBuilder builder) {
        return builder
                .dataSource(remoteDataSource)
                .properties(getVendorProperties())
                .packages("com.example.removetolocal.newentity.entity")
                .persistenceUnit("backupPersistenceUnit")
                .build();
    }

    @Autowired
    private JpaProperties jpaProperties;


    private Map<String, Object> getVendorProperties() {
        Map<String,String> map = new HashMap<>();
        map.put("hibernate.dialect","org.hibernate.dialect.MySQL5Dialect");// 设置对应的数据库方言
        jpaProperties.setProperties(map);
        return properties.determineHibernateProperties(
                jpaProperties.getProperties(), new HibernateSettings());
    }


    @Bean(name = "transactionManagerBackup")
    public PlatformTransactionManager transactionManagerStms(EntityManagerFactoryBuilder builder) {
        return new JpaTransactionManager(entityManagerFactoryStms(builder).getObject());
    }
}
