package com.example.removetolocal.config;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateProperties;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateSettings;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import javax.persistence.EntityManager;
import javax.sql.DataSource;
import java.util.HashMap;
import java.util.Map;

@SuppressWarnings({"SpringAutowiredFieldsWarningInspection", "SpringComponentScan"})
@Slf4j
@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(
        entityManagerFactoryRef = "entityManagerFactoryLocation",
        transactionManagerRef = "transactionManagerLocation",
        //添加原数据dao包名
        basePackages = {"com.example.removetolocal.newdevice.dao",
                "com.example.removetolocal.newtrain.dao",
                "com.example.removetolocal.newuser.dao",
                "com.example.removetolocal.olddevice.dao",
                "com.example.removetolocal.oldentity.dao",
                "com.example.removetolocal.oldtrain.dao",
                "com.example.removetolocal.olduser.dao"}
)
@EnableConfigurationProperties(JpaProperties.class)
public class LocationConfig {
    @Autowired
    @Qualifier("locationDataSource")
    private DataSource locationDataSource;
    @Autowired
    private HibernateProperties properties;

    @Primary
    @Bean(name = "entityManagerLocation")
    public EntityManager entityManager(EntityManagerFactoryBuilder builder) {
        return entityManagerFactoryLocation(builder).getObject().createEntityManager();
    }

    @Primary
    @Bean(name = "entityManagerFactoryLocation")
    public LocalContainerEntityManagerFactoryBean entityManagerFactoryLocation(EntityManagerFactoryBuilder builder) {
        log.info("本地数据源：" + locationDataSource);
        return builder
                .dataSource(locationDataSource)
                .properties(getVendorProperties())
                .packages("com.example.removetolocal.newdevice.domin",
                        "com.example.removetolocal.newtrain.entity",
                        "com.example.removetolocal.newuser.domin",
                        "com.example.removetolocal.olddevice.domin",
                        "com.example.removetolocal.oldentity",
                        "com.example.removetolocal.oldtrain",
                        "com.example.removetolocal.olduser.domin")
                .persistenceUnit("locationPersistenceUnit")
                .build();
    }

    @Autowired
    private JpaProperties jpaProperties;

    private Map<String, Object> getVendorProperties() {
        Map<String,String> map = new HashMap<>();
        map.put("hibernate.dialect","org.hibernate.dialect.MySQL5Dialect");// 设置对应的数据库方言
        jpaProperties.setProperties(map);
        return properties.determineHibernateProperties(
                    jpaProperties.getProperties(), new HibernateSettings());
    }

    @Primary
    @Bean(name = "transactionManagerLocation")
    public PlatformTransactionManager transactionManagerLocation(EntityManagerFactoryBuilder builder) {
        return new JpaTransactionManager(entityManagerFactoryLocation(builder).getObject());
    }
}

