package com.example.removetolocal.newentity.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for device_check_detail
 * 核查详情
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "device_check_detail")
public class DeviceCheckDetail {

	/**
	* 主键id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* 核查账单id
	*/
	@Column(name = "final_check_id")
	private Integer finalCheckId;
	/**
	* 检查组成员1(省A岗)id
	*/
	@Column(name = "check_userA_id")
	private Integer checkUserAId;
	/**
	* 检查组成员2(省A岗)id
	*/
	@Column(name = "check_userB_id")
	private Integer checkUserBId;
	/**
	* 本级经办人id(A岗)
	*/
	@Column(name = "userA_id")
	private Integer userAId;
	/**
	* 本级审核人id(B岗)
	*/
	@Column(name = "userB_id")
	private Integer userBId;
	/**
	* 核查时间
	*/
	@Column(name = "check_time")
	private java.sql.Date checkTime;
	/**
	* 核查单位
	*/
	@Column(name = "check_unit")
	private String checkUnit;
	/**
	* 应查数量
	*/
	@Column(name = "checking_count")
	private Integer checkingCount;
	/**
	* 实查数量
	*/
	@Column(name = "checked_count")
	private Integer checkedCount;
	/**
	* 核查结果
	*/
	@Column(name = "check_result")
	private String checkResult;
	/**
	* 核查详情(装备主键id+核对结果(0缺失1无误2新增,字符x作为分隔符)),例如10x21x32,意为主键id为1的装备缺失,为2的无误,为3的新增
	*/
	@Column(name = "check_detail")
	private String checkDetail;
	/**
	* 核查状态(0:待核查,1:审核失败,2:核查完成)
	*/
	@Column(name = "check_status")
	private Integer checkStatus;
	/**
	* 创建用户id
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* 创建时间
	*/
	@Column(name = "create_time")
	@CreatedDate
	private Date createTime;
	/**
	* 更新用户id
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* 更新时间
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private Date updateTime;
	/**
	* 删除标记(0:未删除，1:已删除)
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* 备注
	*/
	@Column(name = "remark")
	private String remark;
	/**
	* 预留字段2
	*/
	@Column(name = "var2")
	private String var2;
	/**
	* 检查详情名称
	*/
	@Column(name = "title")
	private String title;
	/**
	* checkUseraid
	*/
	@Column(name = "check_useraid")
	private Integer checkUseraid;
	/**
	* checkUserbid
	*/
	@Column(name = "check_userbid")
	private Integer checkUserbid;
	/**
	* useraid
	*/
	@Column(name = "useraid")
	private Integer useraid;
	/**
	* userbid
	*/
	@Column(name = "userbid")
	private Integer userbid;

}
