package com.example.removetolocal.newentity.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for device_check_stat
 * 核查统计表
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "device_check_stat")
public class DeviceCheckStat {

	/**
	* 主键id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* 标题
	*/
	@Column(name = "title")
	private String title;
	/**
	* 副标题
	*/
	@Column(name = "subtitle")
	private String subtitle;
	/**
	* 发起时间
	*/
	@Column(name = "start_time")
	private Date startTime;
	/**
	* 截止时间
	*/
	@Column(name = "end_time")
	private Date endTime;
	/**
	* 统计信息，以JSON形式存储
	*/
	@Column(name = "stat_info")
	private String statInfo;
	/**
	* 创建用户id
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* 创建时间
	*/
	@Column(name = "create_time")
	@CreatedDate
	private Date createTime;
	/**
	* 更新用户id
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* 更新时间
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private Date updateTime;
	/**
	* 删除标记(0:未删除，1:已删除)
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* 核查组成员Aid
	*/
	@Column(name = "check_userA_id")
	private Integer checkUserAId;
	/**
	* 核查组成员Bid
	*/
	@Column(name = "check_UserB_id")
	private Integer checkUserBId;
	/**
	* 备注信息
	*/
	@Column(name = "remark")
	private String remark;
	/**
	* checkUseraid
	*/
	@Column(name = "check_useraid")
	private Integer checkUseraid;
	/**
	* checkUserbid
	*/
	@Column(name = "check_userbid")
	private Integer checkUserbid;
	/**
	* checkType
	*/
	@Column(name = "check_type")
	private Integer checkType;

}
