package com.example.removetolocal.newentity.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for device_destroy_bill
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "device_destroy_bill")
public class DeviceDestroyBill {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* destroyDeviceDetail
	*/
	@Column(name = "destroy_device_detail")
	private String destroyDeviceDetail;
	/**
	* destroyStatus
	*/
	@Column(name = "destroy_status")
	private Integer destroyStatus;
	/**
	* destroyTime
	*/
	@Column(name = "destroy_time")
	private Date destroyTime;
	/**
	* docNumber
	*/
	@Column(name = "doc_number")
	private Integer docNumber;
	/**
	* fileName
	*/
	@Column(name = "file_name")
	private String fileName;
	/**
	* fileUrl
	*/
	@Column(name = "file_url")
	private String fileUrl;
	/**
	* leader
	*/
	@Column(name = "leader")
	private String leader;
	/**
	* startUseraid
	*/
	@Column(name = "start_useraid")
	private Integer startUseraid;
	/**
	* startUserbid
	*/
	@Column(name = "start_userbid")
	private Integer startUserbid;
	/**
	* supervisor
	*/
	@Column(name = "supervisor")
	private String supervisor;
	/**
	* undertaker
	*/
	@Column(name = "undertaker")
	private String undertaker;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* unit
	*/
	@Column(name = "unit")
	private String unit;
	/**
	* destroyFileName
	*/
	@Column(name = "destroy_file_name")
	private String destroyFileName;
	/**
	* destroyFileUrl
	*/
	@Column(name = "destroy_file_url")
	private String destroyFileUrl;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;

}
