package com.example.removetolocal.newentity.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for final_detail
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "final_detail")
public class FinalDetail {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* commission
	*/
	@Column(name = "commission")
	private Integer commission;
	/**
	* horizontal
	*/
	@Column(name = "horizontal")
	private Integer horizontal;
	/**
	* hosting
	*/
	@Column(name = "hosting")
	private Integer hosting;
	/**
	* model
	*/
	@Column(name = "model")
	private String model;
	/**
	* other
	*/
	@Column(name = "other")
	private Integer other;
	/**
	* received
	*/
	@Column(name = "received")
	private Integer received;
	/**
	* reportId
	*/
	@Column(name = "report_id")
	private Integer reportId;
	/**
	* scrapped
	*/
	@Column(name = "scrapped")
	private Integer scrapped;
	/**
	* sending
	*/
	@Column(name = "sending")
	private Integer sending;
	/**
	* total
	*/
	@Column(name = "total")
	private Integer total;
	/**
	* type
	*/
	@Column(name = "type")
	private Integer type;
	/**
	* vertical
	*/
	@Column(name = "vertical")
	private Integer vertical;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;

}
