package com.example.removetolocal.newentity.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for inventory_time
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "inventory_time")
public class InventoryTime {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* timeStep
	*/
	@Column(name = "time_step")
	private Integer timeStep;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;

}
