package com.example.removetolocal.newentity.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for repair_back_bill
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "repair_back_bill")
public class RepairBackBill {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* agent
	*/
	@Column(name = "agent")
	private String agent;
	/**
	* applyNumber
	*/
	@Column(name = "apply_number")
	private String applyNumber;
	/**
	* backCheckDetail
	*/
	@Column(name = "back_check_detail")
	private String backCheckDetail;
	/**
	* backCheckResult
	*/
	@Column(name = "back_check_result")
	private String backCheckResult;
	/**
	* backReciveCheckDetail
	*/
	@Column(name = "back_recive_check_detail")
	private String backReciveCheckDetail;
	/**
	* backReciveCheckResult
	*/
	@Column(name = "back_recive_check_result")
	private String backReciveCheckResult;
	/**
	* backStatus
	*/
	@Column(name = "back_status")
	private Integer backStatus;
	/**
	* billFileName
	*/
	@Column(name = "bill_file_name")
	private String billFileName;
	/**
	* billFileUrl
	*/
	@Column(name = "bill_file_url")
	private String billFileUrl;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* deviceRepairBillId
	*/
	@Column(name = "device_repair_bill_id")
	private Integer deviceRepairBillId;
	/**
	* fileName
	*/
	@Column(name = "file_name")
	private String fileName;
	/**
	* fileUrl
	*/
	@Column(name = "file_url")
	private String fileUrl;
	/**
	* receiveCount
	*/
	@Column(name = "receive_count")
	private Integer receiveCount;
	/**
	* receiveFileName
	*/
	@Column(name = "receive_file_name")
	private String receiveFileName;
	/**
	* receiveFileUrl
	*/
	@Column(name = "receive_file_url")
	private String receiveFileUrl;
	/**
	* receiveTime
	*/
	@Column(name = "receive_time")
	private Date receiveTime;
	/**
	* receiveUnit
	*/
	@Column(name = "receive_unit")
	private String receiveUnit;
	/**
	* receiveUseraId
	*/
	@Column(name = "receive_usera_id")
	private Integer receiveUseraId;
	/**
	* receiveUserbId
	*/
	@Column(name = "receive_userb_id")
	private Integer receiveUserbId;
	/**
	* replayNumber
	*/
	@Column(name = "replay_number")
	private String replayNumber;
	/**
	* sendTime
	*/
	@Column(name = "send_time")
	private Date sendTime;
	/**
	* sendUnit
	*/
	@Column(name = "send_unit")
	private String sendUnit;
	/**
	* sendedCount
	*/
	@Column(name = "sended_count")
	private Integer sendedCount;
	/**
	* sendingCount
	*/
	@Column(name = "sending_count")
	private Integer sendingCount;
	/**
	* startUseraId
	*/
	@Column(name = "start_usera_id")
	private Integer startUseraId;
	/**
	* startUserbId
	*/
	@Column(name = "start_userb_id")
	private Integer startUserbId;
	/**
	* title
	*/
	@Column(name = "title")
	private String title;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* docNum
	*/
	@Column(name = "doc_num")
	private String docNum;
	/**
	* leftSignatureId
	*/
	@Column(name = "left_signature_id")
	private String leftSignatureId;
	/**
	* rightSignatureId
	*/
	@Column(name = "right_signature_id")
	private String rightSignatureId;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;

}
