package com.example.removetolocal.newentity.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for repair_bill
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "repair_bill")
public class RepairBill {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* applyNumber
	*/
	@Column(name = "apply_number")
	private String applyNumber;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* docNum
	*/
	@Column(name = "doc_num")
	private String docNum;
	/**
	* receiveUnit
	*/
	@Column(name = "receive_unit")
	private String receiveUnit;
	/**
	* repairStatus
	*/
	@Column(name = "repair_status")
	private Integer repairStatus;
	/**
	* repairUsera
	*/
	@Column(name = "repair_usera")
	private String repairUsera;
	/**
	* repairUserb
	*/
	@Column(name = "repair_userb")
	private String repairUserb;
	/**
	* replayNumber
	*/
	@Column(name = "replay_number")
	private String replayNumber;
	/**
	* sendUnit
	*/
	@Column(name = "send_unit")
	private String sendUnit;
	/**
	* startUsera
	*/
	@Column(name = "start_usera")
	private String startUsera;
	/**
	* startUserb
	*/
	@Column(name = "start_userb")
	private String startUserb;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* leftSignatureId
	*/
	@Column(name = "left_signature_id")
	private String leftSignatureId;
	/**
	* rightSignatureId
	*/
	@Column(name = "right_signature_id")
	private String rightSignatureId;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;

}
