package com.example.removetolocal.newentity.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for repair_send_bill
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "repair_send_bill")
public class RepairSendBill {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* agent
	*/
	@Column(name = "agent")
	private String agent;
	/**
	* applyNumber
	*/
	@Column(name = "apply_number")
	private String applyNumber;
	/**
	* billFileName
	*/
	@Column(name = "bill_file_name")
	private String billFileName;
	/**
	* billFileUrl
	*/
	@Column(name = "bill_file_url")
	private String billFileUrl;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* deviceRepairBillId
	*/
	@Column(name = "device_repair_bill_id")
	private Integer deviceRepairBillId;
	/**
	* fileName
	*/
	@Column(name = "file_name")
	private String fileName;
	/**
	* fileUrl
	*/
	@Column(name = "file_url")
	private String fileUrl;
	/**
	* receiveCount
	*/
	@Column(name = "receive_count")
	private Integer receiveCount;
	/**
	* receiveFileName
	*/
	@Column(name = "receive_file_name")
	private String receiveFileName;
	/**
	* receiveFileUrl
	*/
	@Column(name = "receive_file_url")
	private String receiveFileUrl;
	/**
	* receiveTime
	*/
	@Column(name = "receive_time")
	private Date receiveTime;
	/**
	* receiveUnit
	*/
	@Column(name = "receive_unit")
	private String receiveUnit;
	/**
	* repairDeviceCheckDetail
	*/
	@Column(name = "repair_device_check_detail")
	private String repairDeviceCheckDetail;
	/**
	* repairDeviceCheckResult
	*/
	@Column(name = "repair_device_check_result")
	private String repairDeviceCheckResult;
	/**
	* repairDeviceDetail
	*/
	@Column(name = "repair_device_detail")
	private String repairDeviceDetail;
	/**
	* repairReciveCheckDetail
	*/
	@Column(name = "repair_recive_check_detail")
	private String repairReciveCheckDetail;
	/**
	* repairReciveCheckResult
	*/
	@Column(name = "repair_recive_check_result")
	private String repairReciveCheckResult;
	/**
	* repairStatus
	*/
	@Column(name = "repair_status")
	private Integer repairStatus;
	/**
	* repairUsera
	*/
	@Column(name = "repair_usera")
	private String repairUsera;
	/**
	* repairUseraId
	*/
	@Column(name = "repair_usera_id")
	private Integer repairUseraId;
	/**
	* repairUserbId
	*/
	@Column(name = "repair_userb_id")
	private Integer repairUserbId;
	/**
	* replayNumber
	*/
	@Column(name = "replay_number")
	private String replayNumber;
	/**
	* sendTime
	*/
	@Column(name = "send_time")
	private Date sendTime;
	/**
	* sendUnit
	*/
	@Column(name = "send_unit")
	private String sendUnit;
	/**
	* sendedCount
	*/
	@Column(name = "sended_count")
	private Integer sendedCount;
	/**
	* sendingCount
	*/
	@Column(name = "sending_count")
	private Integer sendingCount;
	/**
	* startUseraId
	*/
	@Column(name = "start_usera_id")
	private Integer startUseraId;
	/**
	* startUserbId
	*/
	@Column(name = "start_userb_id")
	private Integer startUserbId;
	/**
	* title
	*/
	@Column(name = "title")
	private String title;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;

}
