package com.example.removetolocal.newentity.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for scrap_bill
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "scrap_bill")
public class ScrapBill {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* docNumber
	*/
	@Column(name = "doc_number")
	private String docNumber;
	/**
	* fileName
	*/
	@Column(name = "file_name")
	private String fileName;
	/**
	* fileUrl
	*/
	@Column(name = "file_url")
	private String fileUrl;
	/**
	* leader
	*/
	@Column(name = "leader")
	private String leader;
	/**
	* manager
	*/
	@Column(name = "manager")
	private String manager;
	/**
	* models
	*/
	@Column(name = "models")
	private String models;
	/**
	* names
	*/
	@Column(name = "names")
	private String names;
	/**
	* repairBillId
	*/
	@Column(name = "repair_bill_id")
	private Integer repairBillId;
	/**
	* scrapDetail
	*/
	@Column(name = "scrap_detail")
	private String scrapDetail;
	/**
	* scrapTime
	*/
	@Column(name = "scrap_time")
	private Date scrapTime;
	/**
	* scrapUnit
	*/
	@Column(name = "scrap_unit")
	private String scrapUnit;
	/**
	* supervisor
	*/
	@Column(name = "supervisor")
	private String supervisor;
	/**
	* undertaker
	*/
	@Column(name = "undertaker")
	private String undertaker;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;

}
