package com.example.removetolocal.newentity.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for send_back_bill
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "send_back_bill")
public class SendBackBill {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* deadLine
	*/
	@Column(name = "dead_line")
	private Date deadLine;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* exceptionDes
	*/
	@Column(name = "exception_des")
	private String exceptionDes;
	/**
	* formId
	*/
	@Column(name = "form_id")
	private Integer formId;
	/**
	* involeDevice
	*/
	@Column(name = "invole_device")
	private String involeDevice;
	/**
	* reviewUserId
	*/
	@Column(name = "review_user_id")
	private Integer reviewUserId;
	/**
	* sendBackOut
	*/
	@Column(name = "send_back_out")
	private String sendBackOut;
	/**
	* sendBackOutForm
	*/
	@Column(name = "send_back_out_form")
	private String sendBackOutForm;
	/**
	* sendBackStatistical
	*/
	@Column(name = "send_back_statistical")
	private String sendBackStatistical;
	/**
	* title
	*/
	@Column(name = "title")
	private String title;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* isComplete
	*/
	@Column(name = "is_complete")
	private Integer isComplete;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;

}
