package com.example.removetolocal.newuser.domin;

import com.example.removetolocal.config.BeanHelper;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

import javax.persistence.*;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName Units.java
 * @Description 单位对象
 * @createTime 2020年07月28日 09:23:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
public class Units {
    /**
     * 单位id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "unit_id")
//    @GeneratedValue(generator="UserIdentityGenerator",strategy = GenerationType.AUTO)
//    @GenericGenerator(name = "UserIdentityGenerator", strategy = "UserIdentityGenerator")
    private Integer unitId;

    /**
     * 单位名称
     */
    private String name;

    /**
     * 单位描述
     */
    @Column(name = "unit_desc")
    private String unitDesc;

    /**
     * 等级
     */
    private Integer level;

    /**
     * 是否删除
     */
    @Column(name = "id_del")
    private Integer idDel;

    /**
     * 序列号
     */
    private String code;

    /**
     * 区域id
     */
    @Column(name = "area_id")
    private Integer areaId;

    @Column(name = "old_id")
    private String oldId;

    public com.example.removetolocal.newentity.entity.Units toST() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        return mapper.map(this, com.example.removetolocal.newentity.entity.Units.class);
    }
}
