package com.example.removetolocal.newuser.domin;


import com.example.removetolocal.config.BeanHelper;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

import javax.persistence.*;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName User.java
 * @Description 用户对象
 * @createTime 2020年07月27日 11:19:00
 */

@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
public class User {
    /**
     * 用户
     */

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "user_id")
//    @GeneratedValue(generator="UserIdentityGenerator",strategy = GenerationType.AUTO)
//    @GenericGenerator(name = "UserIdentityGenerator", strategy = "UserIdentityGenerator")
    private Integer userId;

    /**
     * 真实名称
     */
    private String name;

    /**
     * 加密后密码
     */
    private String password;

    /**
     * 未加密密码
     */
    @Column(name = "no_password")
    private String noPassword;

    /**
     * 用户名
     */
    private String username;

    /**
     * 排序
     */
    @Column(name = "show_order")
    private Integer showOrder;

    /**
     * 移动电话
     */
    private String mobile;

    /**
     * 机座
     */
    private String telphone;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 真传
     */
    private String fax;

    /**
     * 状态 默认0、1表示冻结
     */
    @Column(name = "is_del")
    private Integer isDel = 0;

    /**
     * 身份证
     */
    @Column(name = "id_card")
    private String idCard;

    /**
     * 性别
     */
    private Integer sex;

    /**
     * 用户单位
     */
    @Column(name = "units_id")
    private Integer unitsId;

    /**
     * 职务
     */
    private Integer position;

    /**
     * 培训状态 0.已培训 1.已过期 2.未培训 3.快过期
     */
    @Column(name = "train_status")
    private Integer trainStatus;
    /**
     * 单位对象
     */

    @Column(name = "old_id")
    private String oldId;

    @Column(name = "old_code")
    private String oldCode;

    public com.example.removetolocal.newentity.entity.User toST() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        return mapper.map(this, com.example.removetolocal.newentity.entity.User.class);
    }

}
