package com.example.removetolocal.olddevice.domin;

import lombok.Data;
import javax.persistence.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for dev_catalog
 * 设备目录表
*/
@Data
@Entity
@Table(name = "dev_catalog")
public class DevCatalogEntity {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* pid
	*/
	@Column(name = "pid")
	private Integer pid;
	/**
	* 型号
	*/
	@Column(name = "model")
	private String model;
	/**
	* 代号
	*/
	@Column(name = "code")
	private String code;
	/**
	* 配用范围
	*/
	@Column(name = "MatchingArea")
	private Integer matchingArea;
	/**
	* 应用类型
	*/
	@Column(name = "appType")
	private Integer appType;
	/**
	* 密级
	*/
	@Column(name = "Secretclass")
	private Integer secretclass;
	/**
	* 列装日期
	*/
	@Column(name = "startDate")
	private String startDate;
	/**
	* 退装日期
	*/
	@Column(name = "endDate")
	private String endDate;
	/**
	* 类型  
	*/
	@Column(name = "devType")
	private Integer devType;
	/**
	* 形态
	*/
	@Column(name = "style")
	private Integer style;
	/**
	* 单位
	*/
	@Column(name = "unit")
	private Integer unit;
	/**
	* 单价
	*/
	@Column(name = "Price")
	private Double price;
	/**
	* 列装性质
	*/
	@Column(name = "PackingProperty")
	private Integer packingProperty;
	/**
	* 列装状态
	*/
	@Column(name = "status")
	private Integer status;
	/**
	* 可见范围
	*/
	@Column(name = "VisibleRange")
	private Integer visibleRange;
	/**
	* 1.型号目录。 0：具体列装
	*/
	@Column(name = "isModelDir")
	private Integer isModelDir;
	/**
	* 生产单位
	*/
	@Column(name = "Production")
	private String production;
	/**
	* 附件
	*/
	@Column(name = "annex")
	private String annex;
	/**
	* 图片
	*/
	@Column(name = "img")
	private String img;
	/**
	* 创建单位
	*/
	@Column(name = "createSup")
	private String createSup;
	/**
	* 创建用户
	*/
	@Column(name = "createuser")
	private String createuser;
	/**
	* 创建时间
	*/
	@Column(name = "createtime")
	private java.util.Date createtime;
	/**
	* 更新用户
	*/
	@Column(name = "updateuser")
	private String updateuser;
	/**
	* 更新时间
	*/
	@Column(name = "updatetime")
	private java.util.Date updatetime;

}
