package com.example.removetolocal.service.impl;

import com.example.removetolocal.newdevice.dao.DeviceLibraryDao;
import com.example.removetolocal.newentity.dao.StorageBillDao;
import com.example.removetolocal.newentity.entity.StorageBill;
import com.example.removetolocal.newuser.dao.UserDao;
import com.example.removetolocal.olddevice.dao.DevOptlogDao;
import com.example.removetolocal.olddevice.domin.DevOptlog;
import com.example.removetolocal.oldentity.DevInstorage;
import com.example.removetolocal.oldentity.SysFile;
import com.example.removetolocal.oldentity.dao.DevInstorageDao;
import com.example.removetolocal.oldentity.dao.DevInstoragedetailDao;
import com.example.removetolocal.oldentity.dao.SysFileDao;
import com.example.removetolocal.service.StorageService;
import com.example.removetolocal.service.UserService;
import com.example.removetolocal.utils.StringSplitUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

@Service
public class StorageServiceImpl implements StorageService {
    @Autowired
    DevInstorageDao devInstorageDao;
    @Autowired
    DevInstoragedetailDao devInstoragedetailDao;
    @Autowired
    StorageBillDao storageBillDao;
    @Autowired
    UserDao userDao;
    @Autowired
    SysFileDao sysFileDao;
    @Autowired
    UserService userService;
    @Autowired
    DevOptlogDao devOptlogDao;
    @Autowired
    DeviceLibraryDao deviceLibraryDao;
    /**
     * 入库业务转换
     */
    @Override
    public void moveStorage() {
        //入库账单转换
        List<DevInstorage> devInstorages = devInstorageDao.findAll();
        devInstorages.forEach(devInstorage -> {
            if (devInstorage.getStatus()!=1) {
                StorageBill storageBill = new StorageBill();
                storageBill.setApplyNumber(devInstorage.getApplyDocNo());
                storageBill.setReplayNumber(devInstorage.getReplyDocNo());
                storageBill.setCreateTime(devInstorage.getCreateTime());
                storageBill.setUpdateTime(devInstorage.getUpdateTime());
                if (devInstorage.getCreateUser() != null) {
                    if (userDao.findByOldCode(devInstorage.getCreateUser()) != null || userDao.findByOldId(devInstorage.getCreateUser()) != null) {
                        storageBill.setCreateUserId(userDao.findByOldCode(devInstorage.getCreateUser()) == null ? userDao.findByOldId(devInstorage.getCreateUser()).getUserId() : userDao.findByOldCode(devInstorage.getCreateUser()).getUserId());
                    }
                }
                if (devInstorage.getUpdateUser() != null) {
                    if (userDao.findByOldCode(devInstorage.getUpdateUser()) != null || userDao.findByOldId(devInstorage.getUpdateUser()) != null) {
                        storageBill.setUpdateUserId(userDao.findByOldCode(devInstorage.getUpdateUser()) == null ? userDao.findByOldId(devInstorage.getUpdateUser()).getUserId() : userDao.findByOldCode(devInstorage.getUpdateUser()).getUserId());
                    }
                }
                if (devInstorage.getAnnex() != null) {
                    List<Integer> ids = StringSplitUtil.fileIdSplit(devInstorage.getAnnex());
                    if (ids.size() > 0) {
                        SysFile sysFile = sysFileDao.findById(ids.get(0)).get();
                        storageBill.setFileName(sysFile.getFilename());
                        storageBill.setFileUrl(sysFile.getFilepath());
                    }
                }
                storageBill.setReceiveUseraId(userService.getUserByOldId(devInstorage.getHandle()).getUserId());
                storageBill.setSendTime(devInstorage.getIssueTime());
                if (devInstorage.getIssueUnit() != null) {
                    storageBill.setSendUnit(userService.getUnitNameByOldId(devInstorage.getIssueUnit()));
                }
                if (devInstorage.getSender() != null) {
                    storageBill.setSendUserId(userService.getUserNameByOldId(devInstorage.getSender()));
                }
                storageBill.setStorageStatus(2);
                storageBill.setStoragingCount(devInstorage.getTotal());
                storageBill.setStoragedCount(devInstorage.getTotal());
                //根据日志找到所有入库的装备
                List<Integer> deviceOldIds = devOptlogDao.findAllByBillidAndOptType(devInstorage.getId(),12).stream()
                        .map(DevOptlog::getDevId)
                        .collect(Collectors.toList());
                StringBuffer stringBuffer = new StringBuffer();
                deviceOldIds.forEach(integer -> {
                    if (deviceLibraryDao.findByOldId(integer)!=null){
                        stringBuffer.append(deviceLibraryDao.findByOldId(integer).getId());
                        stringBuffer.append("x");
                    }
                });
                storageBill.setStorageDetail(stringBuffer.toString());
                storageBillDao.save(storageBill);
            }
        });
    }
}
