package com.example.removetolocal.task;

import com.example.removetolocal.service.DeviceService;
import com.example.removetolocal.service.StorageService;
import com.example.removetolocal.service.UserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class changeRun implements CommandLineRunner {

    @Autowired
    UserService userService;

    @Autowired
    DeviceService deviceService;

    @Autowired
    StorageService storageService;

    /**
     * Callback used to run the bean.
     *
     * @param args incoming main method arguments
     * @throws Exception on error
     */
    @Override
    public void run(String... args) throws Exception {
        userService.changeEntity();
        log.info("用户模块数据迁移完成");
        deviceService.deviceChange();
        log.info("zb模块数据迁移完成");
        storageService.moveStorage();;
        log.info("入库业务数据迁移完成");
    }
}
