package com.example.removetolocal.newentity.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for matching_device_bill
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "matching_device_bill")
public class MatchingDeviceBill {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* billStatus
	*/
	@Column(name = "bill_status")
	private Integer billStatus;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* deviceDetail
	*/
	@Column(name = "device_detail")
	private String deviceDetail;
	/**
	* fileName
	*/
	@Column(name = "file_name")
	private String fileName;
	/**
	* fileUrl
	*/
	@Column(name = "file_url")
	private String fileUrl;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* useraId
	*/
	@Column(name = "usera_id")
	private Integer useraId;
	/**
	* userbId
	*/
	@Column(name = "userb_id")
	private Integer userbId;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;

}
