package com.example.removetolocal.newentity.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for matching_device_library
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "matching_device_library")
public class MatchingDeviceLibrary {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private Date createTime;
	/**
	* createUnit
	*/
	@Column(name = "create_unit")
	private String createUnit;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* deviceId
	*/
	@Column(name = "device_id")
	private Integer deviceId;
	/**
	* lifeStatus
	*/
	@Column(name = "life_status")
	private Integer lifeStatus;
	/**
	* model
	*/
	@Column(name = "model")
	private String model;
	/**
	* name
	*/
	@Column(name = "name")
	private String name;
	/**
	* rfidCardId
	*/
	@Column(name = "rfid_card_id")
	private String rfidCardId;
	/**
	* rfidSurfaceId
	*/
	@Column(name = "rfid_surface_id")
	private String rfidSurfaceId;
	/**
	* seqNumber
	*/
	@Column(name = "seq_number")
	private String seqNumber;
	/**
	* type
	*/
	@Column(name = "type")
	private String type;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;

}
