package com.example.removetolocal.newentity.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for task
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "task")
public class Task {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* billId
	*/
	@Column(name = "bill_id")
	private Integer billId;
	/**
	* billStatus
	*/
	@Column(name = "bill_status")
	private Integer billStatus;
	/**
	* businessType
	*/
	@Column(name = "business_type")
	private Integer businessType;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* currentPoint
	*/
	@Column(name = "current_point")
	private Integer currentPoint;
	/**
	* customInfo
	*/
	@Column(name = "custom_info",columnDefinition="TEXT")
	private String customInfo;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* involveUsers
	*/
	@Column(name = "involve_users",columnDefinition="TEXT")
	private String involveUsers;
	/**
	* nodeIdDetail
	*/
	@Column(name = "node_id_detail",columnDefinition="TEXT")
	private String nodeIdDetail;
	/**
	* ownUnit
	*/
	@Column(name = "own_unit")
	private Integer ownUnit;
	/**
	* parentTaskId
	*/
	@Column(name = "parent_task_id")
	private Integer parentTaskId;
	/**
	* title
	*/
	@Column(name = "title")
	private String title;
	/**
	* topFlagDetail
	*/
	@Column(name = "top_flag_detail",columnDefinition="TEXT")
	private String topFlagDetail;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* userReadDetail
	*/
	@Column(name = "user_read_detail",columnDefinition="TEXT")
	private String userReadDetail;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;

}
