package com.example.removetolocal.newrepel.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.time.LocalDateTime;

/**
 * BaseEntity.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/9/27 at 1:25 上午
 */

@Data
@NoArgsConstructor
@AllArgsConstructor
@MappedSuperclass
@EntityListeners(AuditingEntityListener.class)
@Where(clause = "delete_tag = 0")
public class BaseEntity {

    /**
     * 主键id
     */
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name = "id")
//    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer id;

    /**
     * 创建用户id
     */
    @CreatedBy
    @Column(name = "create_user_id")
    private Integer createUserId;

    /**
     * 更新用户id
     */
    @LastModifiedBy
    @Column(name = "update_user_id")
    private Integer updateUserId;

    /**
     * 创建时间
     */
    @CreatedDate
    @Column(name = "create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @LastModifiedDate
    @Column(name = "update_time")
    private LocalDateTime updateTime;

    /**
     * 删除标记(0:未删除，1:已删除)
     */
    @Column(name = "delete_tag")
    private Integer deleteTag = 0;
}
