package com.example.removetolocal.newrepel.entity;

import com.example.removetolocal.config.BeanHelper;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.modelmapper.ModelMapper;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DeviceRepel.java
 * @Description DeviceRepel 清退业务id
 * @createTime 2021年01月06日 20:02:00
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update device_check_bill set delete_tag = 1 where id = ?")
@Table(name = "device_repel")
public class DeviceRepel extends BaseEntity {
    /**
     * 数据id
     */
    @Id
    @GeneratedValue
    @Column(name = "id")
    private Integer id;

    /**
     * 清退标题
     */
    @Column(name = "title")
    private String title;
    /**
     * 类型集合多个列装id
     * 页面类型
     */
    @Column(name = "fielding",columnDefinition = "TEXT")
    private String fielding;

    /**
     * 描述
     */
    @Column(name = "describes",columnDefinition = "TEXT")
    private String describes;

    /**
     * 任务范围
     *
     */
    @Column(name = "task_scope",columnDefinition = "TEXT")
    private String taskScope;

    /**
     *征文
     *
     */
    @Column(name = "files",columnDefinition = "TEXT")
    private String files;


    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @Column(name = "time")
    private Date time;

    /**
     * 清退状态
     * 1。全量清退 2。部分清退
     */
    @Column(name = "repel_status")
    private Integer repelStatus;

    /**
     * 发起人名称
     */
    @Column(name = "initiate_name")
    private String initiateName;

    /**
     * 发起单位
     */
    @Column(name = "unit_name")
    private String unitName;

    /**
     * 发起单位id
     */
    @Column(name = "unit_id")
    private Integer unitId;

    public DeviceRepel(String title, String fielding, String describes, String taskScope, String files, Date time, Integer repelStatus, String initiateName, String unitName, Integer unitId) {
        this.title = title;
        this.fielding = fielding;
        this.describes = describes;
        this.taskScope = taskScope;
        this.files = files;
        this.time = time;
        this.repelStatus = repelStatus;
        this.initiateName = initiateName;
        this.unitName = unitName;
        this.unitId = unitId;
    }

    public com.example.removetolocal.newentity.entity.DeviceRepel toST() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        return mapper.map(this, com.example.removetolocal.newentity.entity.DeviceRepel.class);
    }
}
