package com.example.removetolocal.newrepel.entity;

import com.example.removetolocal.config.BeanHelper;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName RepelTaskStatistical.java
 * @Description TODO
 * @createTime 2021年01月07日 09:35:00
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@NoArgsConstructor
@AllArgsConstructor
@Table(name = "repel_task_statistical")
public class RepelTaskStatistical extends BaseEntity {
    /**
     * 数据id
     */
    @Id
    @Column(name = "id")
    private  Integer id;

    /**
     * repelId
     */
    @Column(name = "repel_id")
    private Integer repelId;
    /**
     * 父类taskId
     */
    @Column(name = "father_task_id")
    private Integer fatherTaskId;

    /**
     * taskId
     */
    @Column(name = "task_id")
    private Integer taskId;

    /**
     * 任务状态 1.正常提交 2.延期 3.等待审核
     */
    @Column(name = "task_status")
    private Integer taskStatus;

    /**
     * 区域名称
     */
    @Column(name = "area_name")
    private String  areaName;

    /**
     * 提交的型号和数量 json存储modelCount对象
     */
    @Column(name = "model_count",columnDefinition = "TEXT")
    private String  modelCount;

    /**
     * 描述
     */
    @Column(name = "des",columnDefinition = "TEXT")
    private String des;


    public RepelTaskStatistical(Integer repelId, Integer fatherTaskId, Integer taskId, Integer taskStatus, String areaName) {
        this.repelId = repelId;
        this.fatherTaskId = fatherTaskId;
        this.taskId = taskId;
        this.taskStatus = taskStatus;
        this.areaName = areaName;
    }

    public RepelTaskStatistical(Integer repelId, Integer fatherTaskId, Integer taskId, Integer taskStatus, String areaName, String modelCount, String des) {
        this.repelId = repelId;
        this.fatherTaskId = fatherTaskId;
        this.taskId = taskId;
        this.taskStatus = taskStatus;
        this.areaName = areaName;
        this.modelCount = modelCount;
        this.des = des;
    }

    public com.example.removetolocal.newentity.entity.RepelTaskStatistical toST() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        return mapper.map(this, com.example.removetolocal.newentity.entity.RepelTaskStatistical.class);
    }
}
