package com.example.removetolocal.newstorage.bto;

import com.example.removetolocal.config.BeanHelper;
import com.example.removetolocal.newstorage.entity.Task;
import com.example.removetolocal.utils.StringSplitUtil;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class TaskBto {

    private Integer id;

    private Integer billStatus;

    private String title;

    private Integer parentTaskId;

    private String nodeIdDetail;

    private Integer billId;

    private Integer businessType;

    private Integer ownUnit;

    private Integer updateUserId;

    private Integer currentPoint;

    private String customInfo;

    private Integer createUserId;

    private Date createTime;

    private Date updateTime;

    private List<Integer> topFlagDetailList = new ArrayList<>();

    private List<Integer> userReadDetailList = new ArrayList<>();

    private List<Integer> involveUserIdList = new ArrayList<>();

    private String recordId;

    private Integer oldId;

    public TaskBto(Integer billStatus, String title, Integer parentTaskId, String nodeIdDetail, Integer billId, Integer businessType, Integer ownUnit, Integer currentPoint, String customInfo, List<Integer> involveUserIdList) {
        this.billStatus = billStatus;
        this.title = title;
        this.parentTaskId = parentTaskId;
        this.nodeIdDetail = nodeIdDetail;
        this.billId = billId;
        this.businessType = businessType;
        this.ownUnit = ownUnit;
        this.currentPoint = currentPoint;
        this.customInfo = customInfo;
        this.involveUserIdList = involveUserIdList;
    }


    public TaskBto(Integer status, String title, Integer parentTaskId, String nodeIdDetail, Integer businessType, Integer billId, Integer ownUnit, int startUserId) {
        this.billStatus = status;
        this.title = title;
        this.parentTaskId = parentTaskId;
        this.nodeIdDetail = nodeIdDetail;
        this.businessType = businessType;
        this.billId = billId;
        this.ownUnit = ownUnit;
        List<Integer> involveUserIdList = new ArrayList<>();
        involveUserIdList.add(startUserId);
        this.involveUserIdList = involveUserIdList;
        this.currentPoint = 0;
    }

    /**
     * bto类转化为do类
     */
    public Task toDo() {
        //复制相同属性
        ModelMapper modelMapper = BeanHelper.getUserMapper();
        Task task = modelMapper.map(this, Task.class);
        //set组合字段
        task.setInvolveUsers(StringSplitUtil.idListToString(this.involveUserIdList));
        task.setUserReadDetail(StringSplitUtil.idListToString(this.userReadDetailList));
        task.setTopFlagDetail(StringSplitUtil.idListToString(this.topFlagDetailList));
        return task;
    }

    /**
     * @return 最后一个参与该任务的人员id, 用于任务状态变化时人员不变的情况
     */
    public Integer getLastUserId() {
        return involveUserIdList.get(involveUserIdList.size() - 1);
    }

    /**
     * @return 第一个参与该任务的人员id, 用于任务状态变化时需要返回初始状态的情况
     */
    public Integer getFirstUserId() {
        return involveUserIdList.get(0);
    }
}
