package com.example.removetolocal.newstorage.entity;

import com.example.removetolocal.config.BeanHelper;
import com.example.removetolocal.newstorage.bto.TaskBto;
import com.example.removetolocal.utils.StringSplitUtil;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.*;
import java.util.Date;

/**
 * entity class for task
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "task")
public class Task {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* billId
	*/
	@Column(name = "bill_id")
	private Integer billId;
	/**
	* billStatus
	*/
	@Column(name = "bill_status")
	private Integer billStatus;
	/**
	* businessType
	*/
	@Column(name = "business_type")
	private Integer businessType;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* currentPoint
	*/
	@Column(name = "current_point")
	private Integer currentPoint;
	/**
	* customInfo
	*/
	@Column(name = "custom_info")
	private String customInfo;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag = 0;
	/**
	* involveUsers
	*/
	@Column(name = "involve_users")
	private String involveUsers;
	/**
	* nodeIdDetail
	*/
	@Column(name = "node_id_detail")
	private String nodeIdDetail;
	/**
	* ownUnit
	*/
	@Column(name = "own_unit")
	private Integer ownUnit;
	/**
	* parentTaskId
	*/
	@Column(name = "parent_task_id")
	private Integer parentTaskId;
	/**
	* title
	*/
	@Column(name = "title")
	private String title;
	/**
	* topFlagDetail
	*/
	@Column(name = "top_flag_detail")
	private String topFlagDetail;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* userReadDetail
	*/
	@Column(name = "user_read_detail")
	private String userReadDetail;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;

	@Column(name = "old_id")
	private Integer oldId;

	public Task(String title, Integer parentTaskId, String nodeIdDetail, Integer businessType, Integer billId, Integer ownUnit) {
		this.title = title;
		this.parentTaskId = parentTaskId;
		this.nodeIdDetail = nodeIdDetail;
		this.businessType = businessType;
		this.billId = billId;
		this.ownUnit = ownUnit;
	}

	public Task(Integer status, String title, Integer parentTaskId, String nodeIdDetail, Integer businessType, Integer billId, Integer ownUnit) {
		this.billStatus = status;
		this.title = title;
		this.parentTaskId = parentTaskId;
		this.nodeIdDetail = nodeIdDetail;
		this.businessType = businessType;
		this.billId = billId;
		this.ownUnit = ownUnit;
		this.currentPoint = 0;
	}

	/**
	 * do类转化为bto类
	 */
	public TaskBto parse2Bto() {
		//modelMap复制
		ModelMapper mapper = BeanHelper.getUserMapper();
		TaskBto taskBto = mapper.map(this, TaskBto.class);
		//解析组合字段并添加
		taskBto.setInvolveUserIdList(StringSplitUtil.userIdSplit(this.involveUsers));
		taskBto.setTopFlagDetailList(StringSplitUtil.userIdSplit(this.topFlagDetail));
		taskBto.setUserReadDetailList(StringSplitUtil.userIdSplit(this.userReadDetail));
		return taskBto;
	}

	public com.example.removetolocal.newentity.entity.Task toST() {
		ModelMapper mapper = BeanHelper.getUserMapper();
		return mapper.map(this, com.example.removetolocal.newentity.entity.Task.class);
	}
}
