package com.example.removetolocal.newstorage.entity;

import com.example.removetolocal.config.BeanHelper;
import lombok.Data;
import javax.persistence.*;

import org.modelmapper.ModelMapper;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for task_log
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "task_log")
public class TaskLog {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private java.util.Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag = 0;
	/**
	* fileDetail
	*/
	@Column(name = "file_detail")
	private String fileDetail;
	/**
	* remark
	*/
	@Column(name = "remark")
	private String remark;
	/**
	* taskId
	*/
	@Column(name = "task_id")
	private Integer taskId;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private java.util.Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;

	@Column(name = "old_id")
	private Integer oldId;

	public com.example.removetolocal.newentity.entity.TaskLog toST() {
		ModelMapper mapper = BeanHelper.getUserMapper();
		return mapper.map(this, com.example.removetolocal.newentity.entity.TaskLog.class);
	}
}
