package com.example.removetolocal.newtrain.entity;

import com.example.removetolocal.config.BeanHelper;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

import javax.persistence.*;

/**
 * entity class for train_user
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "train_user")
public class TrainUser {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* 考勤
	*/
	@Column(name = "attendance")
	private String attendance;
	/**
	* 是否发证
	*/
	@Column(name = "certificate")
	private Integer certificate;
	/**
	* 评价
	*/
	@Column(name = "evaluation")
	private String evaluation;
	/**
	* 身份证
	*/
	@Column(name = "id_card")
	private String idCard;
	/**
	* 是否必须报名
	*/
	@Column(name = "is_not_join_user_id")
	private Integer isNotJoinUserId;
	/**
	* 是否报名
	*/
	@Column(name = "is_sign_up")
	private Integer isSignUp;
	/**
	* 手机
	*/
	@Column(name = "mobile")
	private String mobile;
	/**
	* 姓名
	*/
	@Column(name = "name")
	private String name;
	/**
	* 备注
	*/
	@Column(name = "note")
	private String note;
	/**
	* 职务
	*/
	@Column(name = "position")
	private Integer position;
	/**
	* 区块链id
	*/
	@Column(name = "record_id")
	private String recordId;
	/**
	* 分数
	*/
	@Column(name = "score")
	private String score;
	/**
	* 性别
	*/
	@Column(name = "sex")
	private Integer sex;
	/**
	* 培训id
	*/
	@Column(name = "train_id")
	private Integer trainId;
	/**
	* 单位id
	*/
	@Column(name = "units_id")
	private Integer unitsId;
	/**
	* 单位名称
	*/
	@Column(name = "units_name")
	private String unitsName;
	/**
	* 用户id
	*/
	@Column(name = "user_id")
	private Integer userId;
	public TrainUser(Integer trainId, Integer userId, String name, String mobile, String idCard, Integer sex, Integer position, String unitsName, Integer unitsId, String attendance, String score, String evaluation, Integer isSignUp, String note, Integer certificate, Integer isNotJoinUserId) {
		this.trainId = trainId;
		this.userId = userId;
		this.name = name;
		this.mobile = mobile;
		this.idCard = idCard;
		this.sex = sex;
		this.position = position;
		this.unitsName = unitsName;
		this.unitsId = unitsId;
		this.attendance = attendance;
		this.score = score;
		this.evaluation = evaluation;
		this.isSignUp = isSignUp;
		this.note = note;
		this.certificate = certificate;
		this.isNotJoinUserId = isNotJoinUserId;
	}

	public com.example.removetolocal.newentity.entity.TrainUser toST() {
		ModelMapper mapper = BeanHelper.getUserMapper();
		return mapper.map(this, com.example.removetolocal.newentity.entity.TrainUser.class);
	}
}
