package com.example.removetolocal.olddevice.domin;

import lombok.Data;
import javax.persistence.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for dev_optlog
 * 设备操作日志
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "dev_optlog")
public class DevOptlog {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* catalogid
	*/
	@Column(name = "catalogid")
	private Integer catalogid;
	/**
	* 设备id
	*/
	@Column(name = "devId")
	private Integer devId;
	/**
	* 操作时间
	*/
	@Column(name = "optTime")
	private java.util.Date optTime;
	/**
	* 结束时间
	*/
	@Column(name = "overTime")
	private java.util.Date overTime;
	/**
	* 操作类型
	*/
	@Column(name = "optType")
	private Integer optType;
	/**
	* 单据ID
	*/
	@Column(name = "billid")
	private Integer billid;
	/**
	* optUser
	*/
	@Column(name = "optUser")
	private String optUser;
	/**
	* srcCompany
	*/
	@Column(name = "srcCompany")
	private String srcCompany;
	/**
	* descCompany
	*/
	@Column(name = "descCompany")
	private String descCompany;
	/**
	* optcontent
	*/
	@Column(name = "optcontent")
	private String optcontent;
	/**
	* 单据HTML内容
	*/
	@Column(name = "billfile")
	private Integer billfile;
	/**
	* 是否有效。撤回则无效
	*/
	@Column(name = "isValid")
	private Integer isValid;

}
