package com.example.removetolocal.oldentity;

import lombok.Data;
import javax.persistence.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for dev_allot
 * 入库单
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "dev_allot")
public class DevAllot {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* 标题
	*/
	@Column(name = "title")
	private String title;
	/**
	* 文号
	*/
	@Column(name = "docNo")
	private String docNo;
	/**
	* 申请文号
	*/
	@Column(name = "applyDocNo")
	private String applyDocNo;
	/**
	* 批复文号
	*/
	@Column(name = "replyDocNo")
	private String replyDocNo;
	/**
	* 发件人
	*/
	@Column(name = "sendUser")
	private String sendUser;
	/**
	* 配发单位
	*/
	@Column(name = "sendUnit")
	private String sendUnit;
	/**
	* 配发时间
	*/
	@Column(name = "sendTime")
	private java.util.Date sendTime;
	/**
	* 核发人
	*/
	@Column(name = "sendConfirmUser")
	private String sendConfirmUser;
	/**
	* 经办人
	*/
	@Column(name = "handleUser")
	private String handleUser;
	/**
	* 签收人
	*/
	@Column(name = "handleConfirmUser")
	private String handleConfirmUser;
	/**
	* 签收单位
	*/
	@Column(name = "handleUnit")
	private String handleUnit;
	/**
	* 入库时间
	*/
	@Column(name = "handleTime")
	private java.util.Date handleTime;
	/**
	* 发送方附件
	*/
	@Column(name = "annex")
	private String annex;
	/**
	* 接收方附件
	*/
	@Column(name = "HANDLEANNEX")
	private String handleannex;
	/**
	* 备注
	*/
	@Column(name = "remark")
	private String remark;
	/**
	* 配送设备数量
	*/
	@Column(name = "total")
	private Integer total;
	/**
	* 状态 1.配发待确认 2.待接收 3.接收待确认 4.结束
	*/
	@Column(name = "status")
	private Integer status;
	/**
	* 配送单 pdf文件id
	*/
	@Column(name = "billFileid")
	private Integer billFileid;
	/**
	* updateUser
	*/
	@Column(name = "updateUser")
	private String updateUser;
	/**
	* updateTime
	*/
	@Column(name = "updateTime")
	private java.util.Date updateTime;

}
