package com.example.removetolocal.oldentity;

import lombok.Data;
import javax.persistence.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for dev_back
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "dev_back")
public class DevBack {

	/**
	* 装备退回主键Id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* 申请文号
	*/
	@Column(name = "applyDocNo")
	private String applyDocNo;
	/**
	* 批复文号
	*/
	@Column(name = "replyDocNo")
	private String replyDocNo;
	/**
	* 发件人
	*/
	@Column(name = "sendUser")
	private String sendUser;
	/**
	* 退回单位
	*/
	@Column(name = "sendUnit")
	private String sendUnit;
	/**
	* 退回时间
	*/
	@Column(name = "sendTime")
	private java.util.Date sendTime;
	/**
	* 发件确认人
	*/
	@Column(name = "sendConfirmUser")
	private String sendConfirmUser;
	/**
	* 经办人
	*/
	@Column(name = "handleUser")
	private String handleUser;
	/**
	* 签收人
	*/
	@Column(name = "handleConfirmUser")
	private String handleConfirmUser;
	/**
	* 签收单位
	*/
	@Column(name = "handleUnit")
	private String handleUnit;
	/**
	* 签收时间
	*/
	@Column(name = "handleTime")
	private java.util.Date handleTime;
	/**
	* 发送方附件
	*/
	@Column(name = "annex")
	private String annex;
	/**
	* 接收方附件
	*/
	@Column(name = "HANDLEANNEX")
	private String handleannex;
	/**
	* 退回设置总数
	*/
	@Column(name = "total")
	private Integer total;
	/**
	* 1待确认 2 已确认
	*/
	@Column(name = "status")
	private Integer status;
	/**
	* 退回单PDF文档
	*/
	@Column(name = "billFileid")
	private Integer billFileid;
	/**
	* 备注
	*/
	@Column(name = "remark")
	private String remark;

}
