package com.example.removetolocal.oldentity;

import lombok.Data;
import javax.persistence.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for dev_instorage
 * 入库单
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "dev_instorage")
public class DevInstorage {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* 申请文号
	*/
	@Column(name = "applyDocNo")
	private String applyDocNo;
	/**
	* 批复文号
	*/
	@Column(name = "replyDocNo")
	private String replyDocNo;
	/**
	* 配发单位
	*/
	@Column(name = "issueUnit")
	private String issueUnit;
	/**
	* 发送时间
	*/
	@Column(name = "issueTime")
	private java.util.Date issueTime;
	/**
	* 发件人
	*/
	@Column(name = "sender")
	private String sender;
	/**
	* 核发人
	*/
	@Column(name = "approver")
	private String approver;
	/**
	* 经办人
	*/
	@Column(name = "handle")
	private String handle;
	/**
	* 签收人
	*/
	@Column(name = "signatory")
	private String signatory;
	/**
	* signUnit
	*/
	@Column(name = "signUnit")
	private String signUnit;
	/**
	* signTime
	*/
	@Column(name = "signTime")
	private java.util.Date signTime;
	/**
	* 附件
	*/
	@Column(name = "annex")
	private String annex;
	/**
	* 备注
	*/
	@Column(name = "remark")
	private String remark;
	/**
	* 入库设备数量
	*/
	@Column(name = "total")
	private Integer total;
	/**
	* 0 草稿 1待入库 2 已入库
	*/
	@Column(name = "status")
	private Integer status;
	/**
	* createUser
	*/
	@Column(name = "createUser")
	private String createUser;
	/**
	* createTime
	*/
	@Column(name = "createTime")
	private java.util.Date createTime;
	/**
	* updateUser
	*/
	@Column(name = "updateUser")
	private String updateUser;
	/**
	* updateTime
	*/
	@Column(name = "updateTime")
	private java.util.Date updateTime;
	/**
	* recordIds
	*/
	@Column(name = "recordIds")
	private String recordIds;

}
