package com.example.removetolocal.oldentity;

import lombok.Data;
import javax.persistence.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for dev_repair_receive
 * 设备操作日志
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "dev_repair_receive")
public class DevRepairReceive {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* title
	*/
	@Column(name = "title")
	private String title;
	/**
	* 文号
	*/
	@Column(name = "docNo")
	private String docNo;
	/**
	* 申请单位
	*/
	@Column(name = "applyUnit")
	private String applyUnit;
	/**
	* 申请人
	*/
	@Column(name = "applyUser")
	private String applyUser;
	/**
	* 申请时间
	*/
	@Column(name = "applyTime")
	private java.util.Date applyTime;
	/**
	* 申请确认人
	*/
	@Column(name = "applyConfirmUser")
	private String applyConfirmUser;
	/**
	* 领取单位
	*/
	@Column(name = "handleUnit")
	private String handleUnit;
	/**
	* 领取经手人
	*/
	@Column(name = "handleUser")
	private String handleUser;
	/**
	* 领取核验人
	*/
	@Column(name = "handleConfirmUser")
	private String handleConfirmUser;
	/**
	* 办理时间
	*/
	@Column(name = "handleTime")
	private java.util.Date handleTime;
	/**
	* 发送方附件
	*/
	@Column(name = "annex")
	private String annex;
	/**
	* 接收方附件
	*/
	@Column(name = "HANDLEANNEX")
	private String handleannex;
	/**
	* 状态 1.发件方待确认 2.待领取 3.领取待确认 4.结束
	*/
	@Column(name = "status")
	private Integer status;
	/**
	* total
	*/
	@Column(name = "total")
	private Integer total;
	/**
	* 领取单id
	*/
	@Column(name = "billFileid")
	private Integer billFileid;

}
