package com.example.removetolocal.oldentity;

import lombok.Data;
import javax.persistence.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for dev_repairdetail
 * 设备操作日志
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "dev_repairdetail")
public class DevRepairdetail {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* 维修单id
	*/
	@Column(name = "repairid")
	private Integer repairid;
	/**
	* repairReceiveid
	*/
	@Column(name = "repairReceiveid")
	private Integer repairReceiveid;
	/**
	* 对应的领取单
	*/
	@Column(name = "frontRepairid")
	private Integer frontRepairid;
	/**
	* 设备id
	*/
	@Column(name = "devId")
	private Integer devId;
	/**
	* serNum
	*/
	@Column(name = "serNum")
	private String serNum;
	/**
	* proNum
	*/
	@Column(name = "proNum")
	private String proNum;
	/**
	* model
	*/
	@Column(name = "model")
	private String model;
	/**
	* 所属单位
	*/
	@Column(name = "ownUnit")
	private String ownUnit;
	/**
	* applyUnit
	*/
	@Column(name = "applyUnit")
	private String applyUnit;
	/**
	* applyTime
	*/
	@Column(name = "applyTime")
	private java.util.Date applyTime;
	/**
	* 所在单位。 
	*/
	@Column(name = "handleUnit")
	private String handleUnit;
	/**
	* 故障说明
	*/
	@Column(name = "errorDesc")
	private String errorDesc;
	/**
	* memo
	*/
	@Column(name = "memo")
	private String memo;
	/**
	* 维修单位
	*/
	@Column(name = "repairUnit")
	private String repairUnit;
	/**
	* repairUser
	*/
	@Column(name = "repairUser")
	private String repairUser;
	/**
	* repairTime
	*/
	@Column(name = "repairTime")
	private java.util.Date repairTime;
	/**
	* 是否修复
	*/
	@Column(name = "isRepairok")
	private Boolean isRepairok;
	/**
	* 处理结果
	*/
	@Column(name = "repairDesc")
	private String repairDesc;
	/**
	* 是否替换
	*/
	@Column(name = "isreplace")
	private Boolean isreplace;
	/**
	* 新的设备序列号
	*/
	@Column(name = "newSerNum")
	private String newSerNum;
	/**
	* 新的生产序列号
	*/
	@Column(name = "newProNum")
	private String newProNum;
	/**
	* 1 待修 ，2 已送修 ，3 维修中 ，4 已修复 ，5 待领取 ，6 待接收 ，7 已取回 
	*/
	@Column(name = "status")
	private Integer status;
	/**
	* 是否已读，0：未读，1：已读
	*/
	@Column(name = "isRead")
	private Boolean isRead;

}
