package com.example.removetolocal.oldentity;

import lombok.Data;
import javax.persistence.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for dev_selfcheck
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "dev_selfcheck")
public class DevSelfcheck {

	/**
	* 主键Id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* 自查时间
	*/
	@Column(name = "checkDate")
	private java.sql.Date checkDate;
	/**
	* 自查单位Id
	*/
	@Column(name = "comId")
	private String comId;
	/**
	* 自查结果 0 正常  1异常 2少于 3多出
	*/
	@Column(name = "result")
	private Integer result;
	/**
	* 检查人
	*/
	@Column(name = "checkUser")
	private String checkUser;
	/**
	* 确认人
	*/
	@Column(name = "confirmUser")
	private String confirmUser;
	/**
	* 检查状态 0未检 1已查 2已确认 3确认不通过
	*/
	@Column(name = "state")
	private Integer state;
	/**
	* 创建人
	*/
	@Column(name = "creator")
	private String creator;
	/**
	* 创建单位Id
	*/
	@Column(name = "createCompanyId")
	private String createCompanyId;
	/**
	* 创建日期
	*/
	@Column(name = "createTime")
	private java.util.Date createTime;
	/**
	* 备注
	*/
	@Column(name = "remake")
	private String remake;
	/**
	* 自查周期
	*/
	@Column(name = "cycle")
	private Integer cycle;
	/**
	* 是否上报 0未上报 1已上报
	*/
	@Column(name = "isSubmit")
	private Integer isSubmit;
	/**
	* 年份
	*/
	@Column(name = "year")
	private Integer year;
	/**
	* 自查任务标题
	*/
	@Column(name = "title")
	private String title;
	/**
	* 自查任务批次
	*/
	@Column(name = "batchCode")
	private String batchCode;
	/**
	* 任务持续时间
	*/
	@Column(name = "duration")
	private Integer duration;
	/**
	* 接收人
	*/
	@Column(name = "receivers")
	private String receivers;
	/**
	* 接收人姓名
	*/
	@Column(name = "receiverNames")
	private String receiverNames;
	/**
	* 确认时间
	*/
	@Column(name = "confirmTime")
	private java.util.Date confirmTime;
	/**
	* annex
	*/
	@Column(name = "annex")
	private String annex;

}
