package com.example.removetolocal.oldentity;

import lombok.Data;
import javax.persistence.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for dev_selfcheckdetail
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "dev_selfcheckdetail")
public class DevSelfcheckdetail {

	/**
	* 主键Id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* 自查主表Id
	*/
	@Column(name = "mainId")
	private Integer mainId;
	/**
	* 设备Id
	*/
	@Column(name = "deviceId")
	private Integer deviceId;
	/**
	* RFID
	*/
	@Column(name = "rfid")
	private String rfid;
	/**
	* 检查结果 0正常 1异常 2丢失 3多出
	*/
	@Column(name = "result")
	private Integer result;
	/**
	* 备注
	*/
	@Column(name = "remake")
	private String remake;
	/**
	* deviceName
	*/
	@Column(name = "deviceName")
	private String deviceName;
	/**
	* 装备父Id
	*/
	@Column(name = "pid")
	private Integer pid;

}
