package com.example.removetolocal.oldentity;

import lombok.Data;
import javax.persistence.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for dev_tasklog
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "dev_tasklog")
public class DevTasklog {

	/**
	* 主键id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* 任务类型
	*/
	@Column(name = "taskId")
	private Integer taskId;
	/**
	* 处理人
	*/
	@Column(name = "operater")
	private String operater;
	/**
	* 处理单位
	*/
	@Column(name = "operateCompanyId")
	private String operateCompanyId;
	/**
	* 处理时间
	*/
	@Column(name = "operateTime")
	private java.util.Date operateTime;
	/**
	* 操作说明
	*/
	@Column(name = "note")
	private String note;

}
