package com.example.removetolocal.oldrepel.entity;

import com.example.removetolocal.newrepel.entity.DeviceRepelDetail;
import lombok.Data;
import javax.persistence.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;


/**
 * entity class for dev_scrap
 * 报废主表
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update dev_scrap set delete_tag = 1 where id = ?")
@Table(name = "dev_scrap")
public class DevScrap {

	/**
	* 主键
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* 通知id
	*/
	@Column(name = "noticeId")
	private Integer noticeId;
	/**
	* applyDocNo
	*/
	@Column(name = "applyDocNo")
	private String applyDocNo;
	/**
	* replyDocNo
	*/
	@Column(name = "replyDocNo")
	private String replyDocNo;
	/**
	* 标题
	*/
	@Column(name = "title")
	private String title;
	/**
	* 发起单位
	*/
	@Column(name = "applyUnit")
	private String applyUnit;
	/**
	* 发起人
	*/
	@Column(name = "applyUser")
	private String applyUser;
	/**
	* 发起确认人
	*/
	@Column(name = "applyConfirmUser")
	private String applyConfirmUser;
	/**
	* 发起时间
	*/
	@Column(name = "applyTime")
	private java.util.Date applyTime;
	/**
	* 收件单位
	*/
	@Column(name = "handleUnit")
	private String handleUnit;
	/**
	* 收件人
	*/
	@Column(name = "handleUser")
	private String handleUser;
	/**
	* 收件确认人
	*/
	@Column(name = "handleConfirmUser")
	private String handleConfirmUser;
	/**
	* 收件时间
	*/
	@Column(name = "handleTime")
	private java.util.Date handleTime;
	/**
	* 发送方附件
	*/
	@Column(name = "annex")
	private String annex;
	/**
	* 接收方附件
	*/
	@Column(name = "HANDLEANNEX")
	private String handleannex;
	/**
	* 状态 -1.退回 0.删除失效 1.待确认 4.完成
	*/
	@Column(name = "status")
	private Integer status;
	/**
	* 应报废总量
	*/
	@Column(name = "total")
	private Integer total;
	/**
	* 实报废总量
	*/
	@Column(name = "realTotal")
	private Integer realTotal;
	/**
	* 报废单pdf文件id
	*/
	@Column(name = "billFileid")
	private Integer billFileid;
	/**
	* 是否已确认
	*/
	@Column(name = "isConfirm")
	private Integer isConfirm;
	/**
	* 是否已下发通知
	*/
	@Column(name = "isNotice")
	private Integer isNotice;

	public DeviceRepelDetail toDeviceRepelDetail(){
		//为null的需要set进来 具体看字段
		return new DeviceRepelDetail(null,applyDocNo,null,replyDocNo,null,null,null,null,applyTime,handleTime,null,null,null,null,null,null,null,null,null,null,6,total,total,total,null,null,null,null,null,null,null,null,null,null,1);
	}

}
