package com.example.removetolocal.oldrepel.entity;

import lombok.Data;
import javax.persistence.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for dev_scrap_detail
 * 报废详情表
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update dev_scrap_detail set delete_tag = 1 where id = ?")
@Table(name = "dev_scrap_detail")
public class DevScrapDetail {

	/**
	* 主键
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* 报废id
	*/
	@Column(name = "scrapId")
	private Integer scrapId;
	/**
	* 装备id
	*/
	@Column(name = "devId")
	private Integer devId;
	/**
	* serNum
	*/
	@Column(name = "serNum")
	private String serNum;
	/**
	* proNum
	*/
	@Column(name = "proNum")
	private String proNum;
	/**
	* ownUnit
	*/
	@Column(name = "ownUnit")
	private String ownUnit;
	/**
	* 是否退回。 通知单如果无需退回直接以退回
	*/
	@Column(name = "isBack")
	private Integer isBack;
	/**
	* 备注
	*/
	@Column(name = "memo")
	private String memo;

}
