package com.example.removetolocal.oldrepel.entity;

import com.example.removetolocal.newrepel.entity.DeviceRepel;
import lombok.Data;
import javax.persistence.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for dev_scrapnotice
 * 报废通知
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update dev_scrapnotice set delete_tag = 1 where id = ?")
@Table(name = "dev_scrapnotice")
public class DevScrapnotice {

	/**
	* 主键
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* 关联上级通知
	*/
	@Column(name = "pid")
	private Integer pid;
	/**
	* 标题
	*/
	@Column(name = "title")
	private String title;
	/**
	* 文号
	*/
	@Column(name = "docNo")
	private String docNo;
	/**
	* 发起人
	*/
	@Column(name = "applyUser")
	private String applyUser;
	/**
	* 核发人
	*/
	@Column(name = "applyConfirmUser")
	private String applyConfirmUser;
	/**
	* 发起单位
	*/
	@Column(name = "applyUnit")
	private String applyUnit;
	/**
	* 创建时间
	*/
	@Column(name = "createTime")
	private java.util.Date createTime;
	/**
	* 发起时间
	*/
	@Column(name = "applyTime")
	private java.util.Date applyTime;
	/**
	* 通知范围：1.全省 2.全市 3.指定单位
	*/
	@Column(name = "noticeRange")
	private Boolean noticeRange;
	/**
	* 接收单位集合，多个之间用'，隔开'
	*/
	@Column(name = "acceptUnits")
	private String acceptUnits;
	/**
	* 截至时间
	*/
	@Column(name = "entTime")
	private java.util.Date entTime;
	/**
	* 列装id列表。多个之间用,隔开
	*/
	@Column(name = "catalogIds")
	private String catalogIds;
	/**
	* 入库方式
	*/
	@Column(name = "instorageType")
	private String instorageType;
	/**
	* 状态 0.已删除 1.草稿 3.已发布  4.已撤销
	*/
	@Column(name = "status")
	private Integer status;
	/**
	* 备注
	*/
	@Column(name = "memo")
	private String memo;
	/**
	* 是否退回装备。 1退回 0保留
	*/
	@Column(name = "isBackDev")
	private Integer isBackDev;
	/**
	* 附件
	*/
	@Column(name = "annex")
	private String annex;

	public DeviceRepel toDeviceRepel(){
		return new DeviceRepel(title,catalogIds,memo,acceptUnits,"",entTime,1,applyUser,"",Integer.valueOf(applyUnit));
	}

}
